/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ui;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.apache.lucene.document.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.java.BinaryElementOpen;
import org.netbeans.modules.java.source.ui.JavaTypeDescription;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexImplEvent;
import org.netbeans.modules.java.source.usages.ClassIndexImplListener;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.DocumentUtil;
import org.netbeans.modules.parsing.lucene.support.Convertor;
import org.netbeans.modules.parsing.lucene.support.Index;
import org.netbeans.modules.parsing.lucene.support.IndexManager;
import org.netbeans.modules.parsing.lucene.support.Queries;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.jumpto.support.NameMatcherFactory;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.jumpto.type.TypeProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class JavaTypeProvider
implements TypeProvider {
    private static final Logger LOGGER = Logger.getLogger(JavaTypeProvider.class.getName());
    private static final Level LEVEL = Level.FINE;
    private static final Collection<? extends JavaTypeDescription> ACTIVE = Collections.unmodifiableSet(new HashSet());
    private Map<URI, CacheItem> rootCache;
    private final AtomicBoolean canceled = new AtomicBoolean();
    private ClasspathInfo cpInfo;
    private final TypeElementFinder.Customizer customizer;

    public String name() {
        return "java";
    }

    public String getDisplayName() {
        return "Java Classes";
    }

    public void cleanup() {
        this.canceled.set(false);
        DataCache.clear();
        this.setRootCache(null);
    }

    public void cancel() {
        this.canceled.set(true);
    }

    public JavaTypeProvider() {
        this(null, null);
    }

    public JavaTypeProvider(ClasspathInfo cpInfo, TypeElementFinder.Customizer customizer) {
        this.cpInfo = cpInfo;
        this.customizer = customizer;
    }

    public void computeTypeNames(TypeProvider.Context context, final TypeProvider.Result res) {
        this.canceled.set(false);
        String originalText = context.getText();
        SearchType searchType = context.getSearchType();
        this.doComputeTypeNames(searchType, originalText, new ResultHandler<JavaTypeDescription>(){
            final /* synthetic */ JavaTypeProvider this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void setMessage(String msg) {
                res.setMessage(msg);
            }

            @Override
            public void setHighlightText(String text) {
                res.setHighlightText(text);
            }

            @Override
            public void pendingResult() {
                res.pendingResult();
            }

            @Override
            public void runRoot(FileObject root, ResultHandler.Exec exec) throws IOException, InterruptedException {
                exec.run();
            }

            @Override
            public JavaTypeDescription create(CacheItem cacheItem, ElementHandle<TypeElement> handle, String simpleName, String relativePath) {
                return new JavaTypeDescription(cacheItem, handle, simpleName, relativePath);
            }

            @Override
            public void addResult(List<? extends JavaTypeDescription> types) {
                res.addResult(types);
            }
        }, this.canceled);
    }

    public <T> void doComputeTypeNames(SearchType searchType, String originalText, final ResultHandler<T> handler, final AtomicBoolean canceled) {
        String typeName;
        Pattern packageName;
        boolean isFullyQualifiedName;
        Map<URI, CacheItem> c;
        final DataCache dataCache = DataCache.forText(originalText, searchType);
        assert (dataCache != null);
        CacheItem.DataCacheCallback callBack = new CacheItem.DataCacheCallback(){
            final /* synthetic */ JavaTypeProvider this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void handleDataCacheChange(@NonNull CacheItem ci) {
                assert (ci != null);
                dataCache.put(ci, null);
            }
        };
        boolean hasBinaryOpen = Lookup.getDefault().lookup(BinaryElementOpen.class) != null;
        final ClassIndex.NameKind nameKind = switch (searchType) {
            case SearchType.EXACT_NAME -> ClassIndex.NameKind.SIMPLE_NAME;
            case SearchType.CASE_INSENSITIVE_EXACT_NAME -> ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP;
            case SearchType.PREFIX -> ClassIndex.NameKind.PREFIX;
            case SearchType.CASE_INSENSITIVE_PREFIX -> ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX;
            case SearchType.REGEXP -> ClassIndex.NameKind.REGEXP;
            case SearchType.CASE_INSENSITIVE_REGEXP -> ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP;
            case SearchType.CAMEL_CASE -> ClassIndex.NameKind.CAMEL_CASE;
            case SearchType.CASE_INSENSITIVE_CAMEL_CASE -> ClassIndex.NameKind.CAMEL_CASE_INSENSITIVE;
            default -> throw new RuntimeException("Unexpected search type: " + String.valueOf(searchType));
        };
        Map<URI, CacheItem> rootCache = this.getRootCache();
        if (rootCache == null) {
            HashMap<URI, CacheItem> sources = null;
            if (this.cpInfo == null) {
                sources = new HashMap<URI, CacheItem>();
                Collection srcRoots = QuerySupport.findRoots((Project)null, Collections.singleton("classpath/source"), Collections.emptySet(), Collections.emptySet());
                for (Object root : srcRoots) {
                    if (canceled.get()) {
                        return;
                    }
                    URL rootUrl = root.toURL();
                    if (canceled.get()) {
                        return;
                    }
                    try {
                        sources.put(rootUrl.toURI(), new CacheItem(rootUrl, "classpath/source", callBack));
                    }
                    catch (URISyntaxException ex) {
                        LOGGER.log(Level.INFO, "Cannot convert root {0} into URI, ignoring.", rootUrl);
                    }
                }
                Collection binRoots = QuerySupport.findRoots((Project)null, Collections.emptySet(), Collections.emptySet(), Arrays.asList("classpath/compile", "classpath/boot"));
                for (FileObject root : binRoots) {
                    SourceForBinaryQuery.Result result;
                    if (canceled.get()) {
                        return;
                    }
                    rootUrl = root.toURL();
                    if (!hasBinaryOpen && (result = SourceForBinaryQuery.findSourceRoots((URL)rootUrl)).getRoots().length == 0) continue;
                    if (canceled.get()) {
                        return;
                    }
                    try {
                        URI rootURI = ((URL)rootUrl).toURI();
                        if (sources.containsKey(rootURI)) continue;
                        sources.put(rootURI, new CacheItem((URL)rootUrl, "classpath/boot", callBack));
                    }
                    catch (URISyntaxException ex) {
                        LOGGER.log(Level.INFO, "Cannot convert root {0} into URI, ignoring.", rootUrl);
                    }
                }
            } else {
                List bootRoots = this.cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT).entries();
                List compileRoots = this.cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE).entries();
                List sourceRoots = this.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE).entries();
                sources = new HashMap(bootRoots.size() + compileRoots.size() + sourceRoots.size());
                String[] cpType = new String[1];
                rootUrl = bootRoots.iterator();
                while (rootUrl.hasNext()) {
                    ClassPath.Entry entry = (ClassPath.Entry)rootUrl.next();
                    if (canceled.get()) {
                        return;
                    }
                    cpType[0] = "classpath/boot";
                    for (URL root : JavaTypeProvider.translate(entry.getURL(), cpType)) {
                        try {
                            sources.put(root.toURI(), new CacheItem(root, cpType[0], callBack));
                        }
                        catch (URISyntaxException ex) {
                            LOGGER.log(Level.INFO, "Cannot convert root {0} into URI, ignoring.", entry.getURL());
                        }
                    }
                }
                for (ClassPath.Entry entry : compileRoots) {
                    if (canceled.get()) {
                        return;
                    }
                    cpType[0] = "classpath/compile";
                    for (URL root : JavaTypeProvider.translate(entry.getURL(), cpType)) {
                        try {
                            sources.put(root.toURI(), new CacheItem(root, cpType[0], callBack));
                        }
                        catch (URISyntaxException ex) {
                            LOGGER.log(Level.INFO, "Cannot convert root {0} into URI, ignoring.", entry.getURL());
                        }
                    }
                }
                for (ClassPath.Entry entry : sourceRoots) {
                    if (canceled.get()) {
                        return;
                    }
                    try {
                        sources.put(entry.getURL().toURI(), new CacheItem(entry.getURL(), "classpath/source", callBack));
                    }
                    catch (URISyntaxException ex) {
                        LOGGER.log(Level.INFO, "Cannot convert root {0} into URI, ignoring.", entry.getURL());
                    }
                }
            }
            if (!canceled.get()) {
                if (LOGGER.isLoggable(LEVEL)) {
                    LOGGER.log(LEVEL, "Querying following roots:");
                    for (CacheItem ci : sources.values()) {
                        LOGGER.log(LEVEL, "  {0}; binary={1}", new Object[]{ci.getRoot().toURI(), ci.isBinary()});
                    }
                    LOGGER.log(LEVEL, "-------------------------");
                }
                this.setRootCache(sources);
            } else {
                return;
            }
        }
        if ((c = this.getRootCache()) == null) {
            return;
        }
        final ArrayList<Object> types = new ArrayList<Object>(c.size() * 20);
        boolean scanInProgress = SourceUtils.isScanInProgress();
        if (scanInProgress) {
            String warningKind = NbBundle.getMessage(JavaTypeProvider.class, (String)"LBL_TypeKind");
            String message = NbBundle.getMessage(JavaTypeProvider.class, (String)"LBL_ScanInProgress_warning", (Object)warningKind);
            handler.setMessage(message);
        } else {
            handler.setMessage(null);
        }
        int lastIndexOfDot = originalText.lastIndexOf(".");
        boolean bl = isFullyQualifiedName = -1 != lastIndexOfDot;
        if (isFullyQualifiedName) {
            packageName = JavaTypeProvider.createPackageRegExp(originalText.substring(0, lastIndexOfDot));
            typeName = originalText.substring(lastIndexOfDot + 1);
            handler.setHighlightText(typeName);
        } else {
            packageName = null;
            typeName = originalText;
        }
        final String textForQuery = JavaTypeProvider.getTextForQuery(typeName, nameKind, searchType);
        LOGGER.log(Level.FINE, "Text For Query ''{0}''.", originalText);
        if (this.customizer != null) {
            for (CacheItem ci : c.values()) {
                HashSet<ElementHandle<TypeElement>> names = new HashSet<ElementHandle<TypeElement>>(this.customizer.query(ci.getClasspathInfo(), textForQuery, nameKind, EnumSet.of(ci.isBinary ? ClassIndex.SearchScope.DEPENDENCIES : ClassIndex.SearchScope.SOURCE)));
                if (nameKind == ClassIndex.NameKind.CAMEL_CASE) {
                    names.addAll(this.customizer.query(ci.getClasspathInfo(), textForQuery, ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX, EnumSet.of(ci.isBinary ? ClassIndex.SearchScope.DEPENDENCIES : ClassIndex.SearchScope.SOURCE)));
                }
                for (ElementHandle elementHandle : names) {
                    ci.initIndex();
                    types.add(handler.create(ci, (ElementHandle<TypeElement>)elementHandle, null, null));
                    if (!canceled.get()) continue;
                    return;
                }
            }
        } else {
            final ArrayDeque<CacheItem> nonCached = new ArrayDeque<CacheItem>(c.size());
            for (CacheItem ci : c.values()) {
                Collection cacheLine = dataCache.get(ci);
                if (cacheLine != null) {
                    types.addAll(cacheLine);
                    continue;
                }
                nonCached.add(ci);
            }
            if (!nonCached.isEmpty()) {
                try {
                    IndexManager.priorityAccess((IndexManager.Action)new IndexManager.Action<Void>(){
                        final /* synthetic */ JavaTypeProvider this$0;
                        {
                            this.this$0 = this$0;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Void run() throws IOException, InterruptedException {
                            for (CacheItem ci : nonCached) {
                                if (canceled.get()) {
                                    return null;
                                }
                                try {
                                    block10: {
                                        ArrayList ct = new ArrayList();
                                        boolean exists = false;
                                        dataCache.put(ci, ACTIVE);
                                        try {
                                            exists = ci.collectDeclaredTypes(packageName, textForQuery, nameKind, handler, ct);
                                            if (exists) {
                                                types.addAll(ct);
                                            }
                                            if (!exists) break block10;
                                            dataCache.compareAndSet(ci, ACTIVE, ct.isEmpty() ? Collections.emptySet() : ct);
                                        }
                                        catch (Throwable throwable) {
                                            if (exists) {
                                                dataCache.compareAndSet(ci, ACTIVE, ct.isEmpty() ? Collections.emptySet() : ct);
                                            } else {
                                                dataCache.put(ci, null);
                                            }
                                            throw throwable;
                                        }
                                        continue;
                                    }
                                    dataCache.put(ci, null);
                                }
                                catch (IOException ioe) {
                                    Exceptions.printStackTrace((Throwable)ioe);
                                }
                                catch (InterruptedException ie) {
                                    throw new AssertionError((Object)ie);
                                }
                            }
                            return null;
                        }
                    });
                }
                catch (IOException | InterruptedException ex) {
                    throw new AssertionError((Object)ex);
                }
            }
            if (canceled.get()) {
                return;
            }
            if (scanInProgress) {
                handler.pendingResult();
            }
        }
        if (!canceled.get()) {
            handler.addResult(types);
        }
    }

    public static void doComputeTypes(SearchType searchType, String originalText, ResultHandler handler, AtomicBoolean canceled) {
        new JavaTypeProvider().doComputeTypeNames(searchType, originalText, handler, canceled);
    }

    static String removeNonJavaChars(String text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!Character.isJavaIdentifierPart(c) && c != '*' && c != '?') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    @CheckForNull
    private Map<URI, CacheItem> getRootCache() {
        if (LOGGER.isLoggable(LEVEL) && this.rootCache == null) {
            LOGGER.log(LEVEL, "Returning null cache entries.", new Exception());
        }
        return this.rootCache == null ? null : Collections.unmodifiableMap(this.rootCache);
    }

    private void setRootCache(@NullAllowed Map<URI, CacheItem> cache) {
        if (LOGGER.isLoggable(LEVEL)) {
            LOGGER.log(LEVEL, "Setting cache entries from " + String.valueOf(this.rootCache) + " to " + String.valueOf(cache) + ".", new Exception());
        }
        if (this.rootCache != null) {
            for (CacheItem ci : this.rootCache.values()) {
                ci.dispose();
            }
        }
        this.rootCache = cache;
    }

    private static String getTextForQuery(String text, ClassIndex.NameKind nameKind, SearchType searchType) {
        return switch (nameKind) {
            case ClassIndex.NameKind.REGEXP, ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP -> NameMatcherFactory.wildcardsToRegexp((String)JavaTypeProvider.removeNonJavaChars(text), (searchType != SearchType.CASE_INSENSITIVE_EXACT_NAME ? 1 : 0) != 0);
            default -> text;
        };
    }

    @CheckForNull
    private static Pattern createPackageRegExp(@NonNull String pkgName) {
        Pattern p;
        StringBuilder sb = new StringBuilder();
        sb.append("(.*\\.)?");
        boolean valid = false;
        for (int i = 0; i < pkgName.length(); ++i) {
            char c = pkgName.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
                valid = true;
                continue;
            }
            if (c == '.') {
                sb.append(".*\\.");
                continue;
            }
            if (c == '*') {
                sb.append(".*");
                continue;
            }
            if (c != '?') continue;
            sb.append(".?");
        }
        if (valid) {
            sb.append(".*(\\..*)?");
            p = Pattern.compile(sb.toString());
        } else {
            p = null;
        }
        LOGGER.log(Level.FINE, "Package pattern: {0}", p);
        return p;
    }

    @NonNull
    private static ClassIndex.NameKind translateSearchType(@NonNull String simpleName, @NonNull ClassIndex.NameKind originalSearchType) {
        if (originalSearchType == ClassIndex.NameKind.SIMPLE_NAME || originalSearchType == ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP) {
            return originalSearchType;
        }
        if (JavaTypeProvider.isAllUpper(simpleName) && simpleName.length() > 1 || Queries.isCamelCase((String)simpleName, null, null)) {
            return JavaTypeProvider.isCaseSensitive(originalSearchType) ? ClassIndex.NameKind.CAMEL_CASE : ClassIndex.NameKind.CAMEL_CASE_INSENSITIVE;
        }
        if (JavaTypeProvider.containsWildCard(simpleName) != -1) {
            return JavaTypeProvider.isCaseSensitive(originalSearchType) ? ClassIndex.NameKind.REGEXP : ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP;
        }
        return JavaTypeProvider.isCaseSensitive(originalSearchType) ? ClassIndex.NameKind.PREFIX : ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX;
    }

    private static boolean isCaseSensitive(@NonNull ClassIndex.NameKind originalNameKind) {
        switch (originalNameKind) {
            case CASE_INSENSITIVE_REGEXP: 
            case CAMEL_CASE_INSENSITIVE: 
            case CASE_INSENSITIVE_PREFIX: {
                return false;
            }
        }
        return true;
    }

    private static int containsWildCard(@NonNull String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '?' && text.charAt(i) != '*') continue;
            return i;
        }
        return -1;
    }

    private static boolean isAllUpper(@NonNull String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isUpperCase(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @NonNull
    private static URL[] translate(@NonNull URL root, @NonNull String[] cpType) {
        FileObject[] roots;
        SourceForBinaryQuery.Result2 res = SourceForBinaryQuery.findSourceRoots2((URL)root);
        if (res.preferSources() && (roots = res.getRoots()).length > 0) {
            cpType[0] = "classpath/source";
            return JavaTypeProvider.asURLs(roots);
        }
        return new URL[]{root};
    }

    @NonNull
    private static URL[] asURLs(FileObject ... fos) {
        URL[] res = new URL[fos.length];
        for (int i = 0; i < fos.length; ++i) {
            res[i] = fos[i].toURL();
        }
        return res;
    }

    private static final class DataCache<T> {
        private static String forText;
        private static final Map<SearchType, DataCache> instances;
        private final Map<CacheItem, Collection<? extends T>> dataCache = new HashMap<CacheItem, Collection<? extends T>>();

        private DataCache() {
        }

        @CheckForNull
        synchronized Collection<? extends T> get(@NonNull CacheItem item) {
            return this.dataCache.get(item);
        }

        synchronized void put(@NonNull CacheItem item, @NullAllowed Collection<? extends T> data) {
            this.dataCache.put(item, data);
        }

        synchronized boolean compareAndSet(@NonNull CacheItem item, @NullAllowed Collection<? extends T> expected, @NullAllowed Collection<? extends T> update) {
            if (this.dataCache.get(item) == expected) {
                this.dataCache.put(item, update);
                return true;
            }
            return false;
        }

        static synchronized void clear() {
            forText = null;
            instances.clear();
        }

        @NonNull
        static synchronized DataCache forText(@NonNull String text, @NonNull SearchType searchType) {
            DataCache cacheInstance;
            Parameters.notNull((CharSequence)"text", (Object)text);
            Parameters.notNull((CharSequence)"searchType", (Object)searchType);
            if (!text.equals(forText)) {
                DataCache.clear();
                forText = text;
            }
            if ((cacheInstance = instances.get(searchType)) == null) {
                cacheInstance = new DataCache();
                instances.put(searchType, cacheInstance);
            }
            return cacheInstance;
        }

        static {
            instances = new EnumMap<SearchType, DataCache>(SearchType.class);
        }
    }

    public static interface ResultHandler<T> {
        public void setMessage(String var1);

        public void setHighlightText(String var1);

        public void pendingResult();

        public void runRoot(FileObject var1, Exec var2) throws IOException, InterruptedException;

        public T create(@NonNull CacheItem var1, @NonNull ElementHandle<TypeElement> var2, @NullAllowed String var3, @NullAllowed String var4);

        public void addResult(List<? extends T> var1);

        public static interface Exec {
            public void run() throws IOException, InterruptedException;
        }
    }

    public static final class CacheItem
    implements ClassIndexImplListener {
        private final URI rootURI;
        private final boolean isBinary;
        private final String cpType;
        private DataCacheCallback callBack;
        private String projectName;
        private Icon projectIcon;
        private ClasspathInfo cpInfo;
        private ClassIndexImpl index;
        private FileObject cachedRoot;

        public CacheItem(@NullAllowed URL root, @NullAllowed String cpType, @NullAllowed DataCacheCallback callBack) throws URISyntaxException {
            this.cpType = cpType;
            this.isBinary = "classpath/boot".equals(cpType) || "classpath/compile".equals(cpType);
            this.rootURI = root == null ? null : root.toURI();
            this.callBack = callBack;
        }

        public int hashCode() {
            return this.rootURI == null ? 0 : this.rootURI.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof CacheItem) {
                CacheItem otherItem = (CacheItem)other;
                return this.rootURI == null ? otherItem.rootURI == null : this.rootURI.equals(otherItem.rootURI);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public FileObject getRoot() {
            CacheItem cacheItem = this;
            synchronized (cacheItem) {
                if (this.cachedRoot != null) {
                    return this.cachedRoot;
                }
            }
            URL root = CacheItem.toURL(this.rootURI);
            FileObject _tmp = root == null ? null : URLMapper.findFileObject((URL)root);
            CacheItem cacheItem2 = this;
            synchronized (cacheItem2) {
                if (this.cachedRoot == null) {
                    this.cachedRoot = _tmp;
                }
            }
            return _tmp;
        }

        public boolean isBinary() {
            return this.isBinary;
        }

        public synchronized String getProjectName() {
            if (!this.isBinary && this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectName;
        }

        public synchronized Icon getProjectIcon() {
            if (!this.isBinary && this.projectIcon == null) {
                this.initProjectInfo();
            }
            return this.projectIcon;
        }

        public ClasspathInfo getClasspathInfo() {
            if (this.cpInfo == null) {
                ClassPath cp = ClassPathSupport.createClassPath((URL[])new URL[]{CacheItem.toURL(this.rootURI)});
                this.cpInfo = this.isBinary ? ("classpath/boot".equals(this.cpType) ? ClasspathInfo.create((ClassPath)cp, (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY) : ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)cp, (ClassPath)ClassPath.EMPTY)) : ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)cp);
            }
            return this.cpInfo;
        }

        private boolean initIndex() {
            if (this.index == null) {
                URL root = CacheItem.toURL(this.rootURI);
                ClassIndexImpl classIndexImpl = this.index = root == null ? null : ClassIndexManager.getDefault().getUsagesQuery(root, true);
                if (this.index == null) {
                    return false;
                }
                this.index.addClassIndexImplListener((ClassIndexImplListener)this);
            }
            return true;
        }

        public <T> boolean collectDeclaredTypes(@NullAllowed Pattern packageName, @NonNull String typeName, @NonNull ClassIndex.NameKind kind, @NonNull ResultHandler<T> resultHandler, @NonNull Collection<? super T> collector) throws IOException, InterruptedException {
            ClassIndex.SearchScope searchScope;
            ClassIndex.SearchScope baseSearchScope;
            if (!this.initIndex()) {
                return false;
            }
            ClassIndex.SearchScope searchScope2 = baseSearchScope = this.isBinary ? ClassIndex.SearchScope.DEPENDENCIES : ClassIndex.SearchScope.SOURCE;
            if (packageName != null) {
                HashSet allPackages = new HashSet();
                this.index.getPackageNames("", false, allPackages);
                Set<? extends String> packages = this.filterPackages(packageName, allPackages);
                searchScope = ClassIndex.createPackageSearchScope((ClassIndex.SearchScopeType)baseSearchScope, (String[])packages.toArray(new String[0]));
                kind = JavaTypeProvider.translateSearchType(typeName, kind);
            } else {
                searchScope = baseSearchScope;
            }
            ClassIndex.NameKind finalKind = kind;
            try {
                resultHandler.runRoot(this.getRoot(), () -> this.lambda$collectDeclaredTypes$0(typeName, finalKind, (ClassIndex.SearchScopeType)searchScope, resultHandler, collector));
            }
            catch (Index.IndexClosedException indexClosedException) {
                // empty catch block
            }
            return true;
        }

        public void typesAdded(@NonNull ClassIndexImplEvent event) {
            if (this.callBack != null) {
                this.callBack.handleDataCacheChange(this);
            }
        }

        public void typesRemoved(@NonNull ClassIndexImplEvent event) {
            if (this.callBack != null) {
                this.callBack.handleDataCacheChange(this);
            }
        }

        public void typesChanged(@NonNull ClassIndexImplEvent event) {
            if (this.callBack != null) {
                this.callBack.handleDataCacheChange(this);
            }
        }

        @CheckForNull
        URI getRootURI() {
            return this.rootURI;
        }

        @CheckForNull
        ClassIndexImpl getClassIndex() {
            return this.index;
        }

        private void initProjectInfo() {
            Project p = FileOwnerQuery.getOwner((URI)this.rootURI);
            if (p != null) {
                ProjectInformation pi = (ProjectInformation)p.getLookup().lookup(ProjectInformation.class);
                this.projectName = pi == null ? p.getProjectDirectory().getNameExt() : pi.getDisplayName();
                this.projectIcon = pi == null ? null : pi.getIcon();
            }
        }

        @NonNull
        private Set<? extends String> filterPackages(@NonNull Pattern packageName, @NonNull Set<? extends String> basePackages) {
            HashSet<String> result = new HashSet<String>();
            for (String string : basePackages) {
                if (!packageName.matcher(string).matches()) continue;
                result.add(string);
            }
            return result;
        }

        private void dispose() {
            this.callBack = null;
            if (this.index != null) {
                this.index.removeClassIndexImplListener((ClassIndexImplListener)this);
            }
        }

        @CheckForNull
        private static URL toURL(@NullAllowed URI uri) {
            try {
                return uri == null ? null : uri.toURL();
            }
            catch (MalformedURLException ex) {
                LOGGER.log(Level.FINE, "Cannot convert URI to URL", ex);
                return null;
            }
        }

        private /* synthetic */ void lambda$collectDeclaredTypes$0(String typeName, ClassIndex.NameKind finalKind, ClassIndex.SearchScopeType searchScope, ResultHandler resultHandler, Collection collector) throws IOException, InterruptedException {
            this.index.getDeclaredElements(typeName, finalKind, Collections.unmodifiableSet(Collections.singleton(searchScope)), DocumentUtil.declaredTypesFieldSelector((boolean)true, (boolean)true), new JavaConvertor(this, resultHandler), collector);
        }

        static interface DataCacheCallback {
            public void handleDataCacheChange(@NonNull CacheItem var1);
        }

        private static class JavaConvertor<T>
        implements Convertor<Document, T> {
            private static final Pattern ANONYMOUS = Pattern.compile(".*\\$\\d+(\\$.+)?");
            private static final Convertor<Document, ElementHandle<TypeElement>> HANDLE_CONVERTOR = DocumentUtil.typeElementConvertor();
            private static final Convertor<Document, String> SOURCE_CONVERTOR = DocumentUtil.sourceNameConvertor();
            private final CacheItem ci;
            private final ResultHandler<T> handler;

            JavaConvertor(@NonNull CacheItem ci, @NonNull ResultHandler<T> handler) {
                this.ci = ci;
                this.handler = handler;
            }

            public T convert(Document p) {
                String binName = DocumentUtil.getSimpleBinaryName((Document)p);
                if (binName == null || ANONYMOUS.matcher(binName).matches() || DocumentUtil.isLocal((Document)p)) {
                    return null;
                }
                ElementHandle eh = (ElementHandle)HANDLE_CONVERTOR.convert((Object)p);
                String sourceName = (String)SOURCE_CONVERTOR.convert((Object)p);
                return eh == null ? null : (T)this.handler.create(this.ci, (ElementHandle<TypeElement>)eh, DocumentUtil.getSimpleName((Document)p), sourceName);
            }
        }
    }
}

