/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.devops.model.BitbucketCloudBuildSource;
import com.oracle.bmc.devops.model.BitbucketServerBuildSource;
import com.oracle.bmc.devops.model.DevopsCodeRepositoryBuildSource;
import com.oracle.bmc.devops.model.GithubBuildSource;
import com.oracle.bmc.devops.model.GitlabBuildSource;
import com.oracle.bmc.devops.model.GitlabServerBuildSource;
import com.oracle.bmc.devops.model.VbsBuildSource;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="connectionType", defaultImpl=BuildSource.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=VbsBuildSource.class, name="VBS"), @JsonSubTypes.Type(value=BitbucketServerBuildSource.class, name="BITBUCKET_SERVER"), @JsonSubTypes.Type(value=GithubBuildSource.class, name="GITHUB"), @JsonSubTypes.Type(value=BitbucketCloudBuildSource.class, name="BITBUCKET_CLOUD"), @JsonSubTypes.Type(value=GitlabServerBuildSource.class, name="GITLAB_SERVER"), @JsonSubTypes.Type(value=DevopsCodeRepositoryBuildSource.class, name="DEVOPS_CODE_REPOSITORY"), @JsonSubTypes.Type(value=GitlabBuildSource.class, name="GITLAB")})
@JsonFilter(value="explicitlySetFilter")
public class BuildSource
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="repositoryUrl")
    private final String repositoryUrl;
    @JsonProperty(value="branch")
    private final String branch;

    @Deprecated
    @ConstructorProperties(value={"name", "repositoryUrl", "branch"})
    protected BuildSource(String name, String repositoryUrl, String branch) {
        this.name = name;
        this.repositoryUrl = repositoryUrl;
        this.branch = branch;
    }

    public String getName() {
        return this.name;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getBranch() {
        return this.branch;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BuildSource(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", repositoryUrl=").append(String.valueOf(this.repositoryUrl));
        sb.append(", branch=").append(String.valueOf(this.branch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BuildSource)) {
            return false;
        }
        BuildSource other = (BuildSource)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.repositoryUrl, other.repositoryUrl) && Objects.equals(this.branch, other.branch) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.repositoryUrl == null ? 43 : this.repositoryUrl.hashCode());
        result = result * 59 + (this.branch == null ? 43 : this.branch.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ConnectionType implements BmcEnum
    {
        Github("GITHUB"),
        Gitlab("GITLAB"),
        GitlabServer("GITLAB_SERVER"),
        BitbucketCloud("BITBUCKET_CLOUD"),
        BitbucketServer("BITBUCKET_SERVER"),
        DevopsCodeRepository("DEVOPS_CODE_REPOSITORY"),
        Vbs("VBS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ConnectionType> map;

        private ConnectionType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConnectionType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ConnectionType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ConnectionType.class);
            map = new HashMap<String, ConnectionType>();
            for (ConnectionType v : ConnectionType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

