/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.IPv4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.fest.assertions.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class IPv4AddressTest {
    private static Logger log = LoggerFactory.getLogger(IPv4AddressTest.class);
    private static final String[] TEST_ADDRESSES = new String[]{"0.0.0.0", "255.255.255.255", "127.0.0.1"};

    @Test
    public void parseIPv4Address() throws GalimatiasParseException {
        for (String testAddress : TEST_ADDRESSES) {
            log.debug("TESTING: {}", (Object)testAddress);
            Assertions.assertThat((String)IPv4Address.parseIPv4Address(testAddress).toString()).isEqualTo((Object)testAddress);
        }
    }

    @Test
    public void equals() throws GalimatiasParseException {
        IPv4Address ip = IPv4Address.parseIPv4Address("127.0.0.1");
        Assertions.assertThat((Object)ip).isEqualTo((Object)ip);
        Assertions.assertThat((Object)ip).isEqualTo((Object)IPv4Address.parseIPv4Address("127.0.0.1"));
        Assertions.assertThat((Object)ip).isNotEqualTo((Object)IPv4Address.parseIPv4Address("127.0.0.2"));
        Assertions.assertThat((Object)ip).isNotEqualTo((Object)"foo");
        Assertions.assertThat((Object)ip).isNotEqualTo(null);
        Assertions.assertThat((String)ip.toHumanString()).isEqualTo((Object)ip.toString());
    }

    @Test(expected=NullPointerException.class)
    public void parseNullAddress() throws GalimatiasParseException {
        IPv4Address.parseIPv4Address(null);
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseEmptyAddress() throws GalimatiasParseException {
        IPv4Address.parseIPv4Address("");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseIllegalCharacter() throws GalimatiasParseException {
        IPv4Address.parseIPv4Address("1.1.x.1");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseTooLongAddress() throws GalimatiasParseException {
        IPv4Address.parseIPv4Address("1.1.1.1.2");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseAddressWithFinalDot() throws GalimatiasParseException {
        IPv4Address.parseIPv4Address("1.1.1.1.");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseTooShortAddress() throws GalimatiasParseException {
        IPv4Address.parseIPv4Address("1.1.1");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseHighValueIPv4Mapped() throws GalimatiasParseException {
        IPv4Address.parseIPv4Address("192.168.1.256");
    }

    @Test
    public void toInetAddress() throws UnknownHostException, GalimatiasParseException {
        for (String testAddress : TEST_ADDRESSES) {
            log.debug("TESTING: {}", (Object)testAddress);
            InetAddress target = InetAddress.getByName(testAddress);
            IPv4Address address = IPv4Address.parseIPv4Address(testAddress);
            Assertions.assertThat((Object)address.toInetAddress()).isEqualTo((Object)target);
            Assertions.assertThat((String)address.toInetAddress().getHostAddress()).isEqualToIgnoringCase(testAddress);
        }
    }
}

