/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion.completors;

import java.io.IOException;
import java.util.ArrayList;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.completors.JavaMethodCompletor;
import org.netbeans.modules.spring.beans.editor.SpringXMLConfigEditorUtils;
import org.netbeans.modules.spring.java.Public;
import org.netbeans.modules.spring.java.Static;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.w3c.dom.Node;

public class FactoryMethodCompletor
extends JavaMethodCompletor {
    private Static staticFlag = Static.YES;

    public FactoryMethodCompletor(int invocationOffset) {
        super(invocationOffset);
    }

    @Override
    protected Public getPublicFlag(CompletionContext context) {
        return Public.DONT_CARE;
    }

    @Override
    protected Static getStaticFlag(CompletionContext context) {
        return this.staticFlag;
    }

    @Override
    protected int getArgCount(CompletionContext context) {
        return -1;
    }

    @Override
    protected String getTypeName(CompletionContext context) {
        Node tag = context.getTag();
        SpringBean mergedBean = SpringXMLConfigEditorUtils.getMergedBean(SpringXMLConfigEditorUtils.getTagAttributes(tag), context.getFileObject());
        if (mergedBean == null) {
            return null;
        }
        final String[] className = new String[]{mergedBean.getClassName()};
        if (mergedBean.getFactoryBean() != null) {
            final String factoryBeanName = mergedBean.getFactoryBean();
            FileObject fo = context.getFileObject();
            SpringConfigModel model = SpringConfigModel.forFileObject(fo);
            if (model == null) {
                return null;
            }
            try {
                model.runReadAction(new Action<SpringBeans>(){
                    final /* synthetic */ FactoryMethodCompletor this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run(SpringBeans beans) {
                        SpringBean bean = beans.findBean(factoryBeanName);
                        if (bean == null) {
                            className[0] = null;
                            return;
                        }
                        className[0] = bean.getClassName();
                    }
                });
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
                className[0] = null;
            }
            this.staticFlag = Static.NO;
        }
        return className[0];
    }

    @Override
    protected Iterable<? extends Element> filter(Iterable<? extends Element> methods) {
        ArrayList<ExecutableElement> ret = new ArrayList<ExecutableElement>();
        for (Element element : methods) {
            ExecutableElement method = (ExecutableElement)element;
            if (method.getReturnType().getKind() == TypeKind.VOID) continue;
            ret.add(method);
        }
        return ret;
    }
}

