/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util.common;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class CommitPopupBuilder {
    private JPopupMenu popupPresenter;
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private Action selectAllAction;

    CommitPopupBuilder() {
    }

    JPopupMenu getPopup(JTextComponent component) {
        if (this.popupPresenter == null) {
            this.build(component.getActionMap());
        }
        boolean textSelected = component.getSelectedText() != null;
        this.cutAction.setEnabled(textSelected);
        this.copyAction.setEnabled(textSelected);
        boolean hasClipboardText = Toolkit.getDefaultToolkit().getSystemClipboard().isDataFlavorAvailable(DataFlavor.stringFlavor);
        this.pasteAction.setEnabled(hasClipboardText);
        return this.popupPresenter;
    }

    private void build(ActionMap actionMap) {
        this.popupPresenter = new JPopupMenu();
        this.cutAction = actionMap.get("cut-to-clipboard");
        this.copyAction = actionMap.get("copy-to-clipboard");
        this.pasteAction = actionMap.get("paste-from-clipboard");
        this.selectAllAction = actionMap.get("select-all");
        this.popupPresenter.add(this.createMenuItem("CTL_MenuItem_Cut", 88, this.cutAction));
        this.popupPresenter.add(this.createMenuItem("CTL_MenuItem_Copy", 67, this.copyAction));
        this.popupPresenter.add(this.createMenuItem("CTL_MenuItem_Paste", 86, this.pasteAction));
        this.popupPresenter.addSeparator();
        this.popupPresenter.add(this.createMenuItem("CTL_MenuItem_SelectAll", 65, this.selectAllAction));
    }

    private JMenuItem createMenuItem(String msgKey, int key, Action action) {
        String msg = NbBundle.getMessage(this.getClass(), (String)msgKey);
        JMenuItem item = new JMenuItem(action);
        Mnemonics.setLocalizedText((AbstractButton)item, (String)msg);
        int keyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        item.setAccelerator(KeyStroke.getKeyStroke(key, keyMask, false));
        return item;
    }
}

