/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.refactoring;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Properties;
import org.netbeans.modules.maven.refactoring.MavenRefactoringElementImplementation;
import org.netbeans.modules.maven.refactoring.ReferringClass;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

class MavenRefactoringPlugin
implements RefactoringPlugin {
    private static final Logger LOG = Logger.getLogger(MavenRefactoringPlugin.class.getName());
    private final RenameRefactoring refactoring;
    private final WhereUsedQuery query;
    private final TreePathHandle handle;

    MavenRefactoringPlugin(WhereUsedQuery query, TreePathHandle handle) {
        this.query = query;
        this.handle = handle;
        this.refactoring = null;
    }

    MavenRefactoringPlugin(RenameRefactoring refactoring, TreePathHandle handle) {
        this.refactoring = refactoring;
        this.handle = handle;
        this.query = null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        if (this.query != null && !this.query.getBooleanValue((Object)"FIND_REFERENCES")) {
            return null;
        }
        final AtomicReference fqn = new AtomicReference();
        CancellableTask<CompilationController> info = new CancellableTask<CompilationController>(){
            final /* synthetic */ MavenRefactoringPlugin this$0;
            {
                this.this$0 = this$0;
            }

            public void run(CompilationController info) throws Exception {
                info.toPhase(JavaSource.Phase.RESOLVED);
                Element e = this.this$0.handle.resolveElement((CompilationInfo)info);
                if (e == null) {
                    LOG.log(Level.WARNING, "no element for {0}", this.this$0.handle);
                    return;
                }
                switch (e.getKind()) {
                    case CLASS: 
                    case INTERFACE: 
                    case ANNOTATION_TYPE: 
                    case ENUM: {
                        fqn.set(info.getElements().getBinaryName((TypeElement)e).toString());
                        break;
                    }
                    default: {
                        LOG.log(Level.FINE, "unexpected element {0}", e);
                    }
                }
            }

            public void cancel() {
            }
        };
        if (this.refactoring != null) {
            ModelOperation renameMainClassProp = model -> {
                Properties pr = model.getProject().getProperties();
                ElementHandle e = this.handle.getElementHandle();
                if (pr != null && e != null) {
                    String oldProperty;
                    String oldName = e.getBinaryName();
                    String newName = this.refactoring.getNewName();
                    if (pr.getProperty("exec.mainClass") != null && (oldProperty = pr.getProperty("exec.mainClass")).equals(oldName)) {
                        int lastIndex = oldName.lastIndexOf(46);
                        String newPropertyValue = newName;
                        if (lastIndex >= 0) {
                            String packageName = oldName.substring(0, lastIndex + 1);
                            newPropertyValue = packageName + newPropertyValue;
                        }
                        pr.setProperty("exec.mainClass", newPropertyValue);
                    }
                }
            };
            try {
                FileObject fo = this.handle.getFileObject();
                Project p = FileOwnerQuery.getOwner((FileObject)fo);
                FileObject pom = p.getProjectDirectory().getFileObject("pom.xml");
                pom.getFileSystem().runAtomicAction(() -> Utilities.performPOMModelOperations((FileObject)pom, Arrays.asList(renameMainClassProp)));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return null;
        }
        FileObject fo = this.handle.getFileObject();
        JavaSource source = fo != null ? JavaSource.forFileObject((FileObject)fo) : null;
        if (source != null) {
            try {
                source.runUserActionTask((Task)info, true);
            }
            catch (IOException x) {
                LOG.log(Level.WARNING, null, x);
            }
        } else {
            LOG.log(Level.WARNING, "no source for {0}", this.handle.getFileObject());
        }
        LOG.log(Level.FINE, "for {0} found FQN: {1}", new Object[]{this.handle, fqn});
        if (fqn.get() != null) {
            long start = System.currentTimeMillis();
            List results = RepositoryQueries.findClassUsagesResult((String)((String)fqn.get()), (List)RepositoryQueries.getLoadedContexts()).getResults();
            long end = System.currentTimeMillis();
            LOG.log(Level.FINE, "took {0}msec to find {1}", new Object[]{end - start, fqn});
            for (RepositoryQueries.ClassUsage result : results) {
                for (String clazz : result.getClasses()) {
                    refactoringElements.add((AbstractRefactoring)this.query, (RefactoringElementImplementation)new MavenRefactoringElementImplementation(new ReferringClass(result.getArtifact(), clazz)));
                }
            }
        }
        return null;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }
}

