/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.module.main;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.css.editor.Css3Utils;
import org.netbeans.modules.css.editor.module.spi.CompletionContext;
import org.netbeans.modules.css.editor.module.spi.CssCompletionItem;
import org.netbeans.modules.css.editor.module.spi.CssEditorModule;
import org.netbeans.modules.css.editor.module.spi.FeatureContext;
import org.netbeans.modules.css.editor.module.spi.Utilities;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeVisitor;
import org.netbeans.modules.web.common.api.LexerUtils;

public class MediaQueriesModule
extends CssEditorModule {
    private static final String[] MEDIA_TYPES = new String[]{"all", "aural", "braille", "embossed", "handheld", "print", "projection", "screen", "tty", "tv"};
    private static Collection<String> MEDIA_FEATURE_NAMES;
    static ElementKind NAMESPACE_ELEMENT_KIND;

    static Collection<String> getMediaFeatures() {
        if (MEDIA_FEATURE_NAMES == null) {
            MEDIA_FEATURE_NAMES = new ArrayList<String>();
            for (MediaFeature mf : MediaFeature.values()) {
                MEDIA_FEATURE_NAMES.addAll(mf.getNames());
            }
        }
        return MEDIA_FEATURE_NAMES;
    }

    @Override
    public List<CompletionProposal> getCompletionProposals(CompletionContext context) {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        Node node = context.getActiveNode();
        switch (node.type()) {
            case error: 
            case recovery: {
                node = node.parent();
            }
        }
        switch (node.type()) {
            case bodyItem: {
                if (context.getActiveTokenId() != CssTokenId.WS || null == LexerUtils.followsToken(context.getTokenSequence(), (TokenId)CssTokenId.MEDIA_SYM, (boolean)true, (boolean)true, (TokenId[])new TokenId[]{CssTokenId.WS, CssTokenId.NL})) break;
                proposals.addAll(MediaQueriesModule.getMediaTypes(context));
                break;
            }
            case mediaType: {
                proposals.addAll(MediaQueriesModule.getMediaTypes(context));
                break;
            }
            case mediaQueryList: {
                if (context.getActiveTokenId() != CssTokenId.COMMA && LexerUtils.followsToken(context.getTokenSequence(), (TokenId)CssTokenId.COMMA, (boolean)true, (boolean)true, (TokenId[])new TokenId[]{CssTokenId.WS}) == null) break;
            }
            case media: {
                if (null != LexerUtils.followsToken(context.getTokenSequence(), (TokenId)CssTokenId.LBRACE, (boolean)true, (boolean)true, (TokenId[])new TokenId[]{CssTokenId.WS, CssTokenId.NL})) break;
            }
            case mediaQuery: {
                proposals.addAll(MediaQueriesModule.getMediaTypes(context));
                break;
            }
            case mediaFeature: {
                proposals.addAll(MediaQueriesModule.getMediaFeatures(context));
                break;
            }
            case mediaExpression: {
                proposals.addAll(MediaQueriesModule.getMediaFeatures(context));
            }
        }
        return Utilities.filterCompletionProposals(proposals, context.getPrefix(), true);
    }

    private static List<CompletionProposal> getMediaFeatures(CompletionContext context) {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        for (String mtype : MediaQueriesModule.getMediaFeatures()) {
            proposals.add((CompletionProposal)CssCompletionItem.createRAWCompletionItem(null, mtype, ElementKind.FIELD, context.getAnchorOffset(), true));
        }
        return proposals;
    }

    private static List<CompletionProposal> getMediaTypes(CompletionContext context) {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        for (String mtype : MEDIA_TYPES) {
            proposals.add((CompletionProposal)CssCompletionItem.createRAWCompletionItem(null, mtype, ElementKind.OTHER, context.getAnchorOffset(), true));
        }
        return proposals;
    }

    @Override
    public <T extends Map<OffsetRange, Set<ColoringAttributes>>> NodeVisitor<T> getSemanticHighlightingNodeVisitor(FeatureContext context, T result) {
        return new NodeVisitor<T>(result){

            public boolean visit(Node node) {
                switch (node.type()) {
                    case mediaType: {
                        ((Map)this.getResult()).put(Css3Utils.getOffsetRange(node), ColoringAttributes.CUSTOM3_SET);
                        break;
                    }
                    case mediaFeature: {
                        ((Map)this.getResult()).put(Css3Utils.getOffsetRange(node), ColoringAttributes.CUSTOM1_SET);
                    }
                }
                return false;
            }
        };
    }

    static {
        NAMESPACE_ELEMENT_KIND = ElementKind.GLOBAL;
    }

    private static enum MediaFeature {
        width(true),
        height(true),
        device_width(true),
        device_height(true),
        orientation(false),
        aspect_ratio(true),
        device_aspect_ratio(true),
        color(true),
        color_index(true),
        monochrome(true),
        resolution(true),
        scan(false),
        grid(false);

        private Collection<String> names;

        private MediaFeature(boolean minMax) {
            String baseName = this.name().replace('_', '-');
            this.names = new ArrayList<String>(minMax ? 3 : 1);
            this.names.add(baseName);
            if (minMax) {
                this.names.add("max-" + baseName);
                this.names.add("min-" + baseName);
            }
        }

        private Collection<String> getNames() {
            return this.names;
        }
    }
}

