/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.core.api.support.java.method;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModel;
import org.openide.util.Parameters;

public final class MethodModelSupport {
    private static final Logger LOG = Logger.getLogger(MethodModelSupport.class.getName());
    private static final String CAPTURED_WILDCARD = "<captured wildcard>";
    private static final String UNKNOWN = "<unknown>";

    private MethodModelSupport() {
    }

    public static MethodModel createMethodModel(CompilationController controller, ExecutableElement method) {
        MethodModel methodModel;
        Parameters.notNull((CharSequence)"controller", (Object)controller);
        Parameters.notNull((CharSequence)"method", (Object)method);
        ArrayList<MethodModel.Variable> parameters = new ArrayList<MethodModel.Variable>();
        for (VariableElement variableElement : method.getParameters()) {
            String string = MethodModelSupport.getTypeName(variableElement.asType());
            String name = variableElement.getSimpleName().toString();
            try {
                parameters.add(MethodModel.Variable.create(string, name));
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
        ArrayList<String> exceptions = new ArrayList<String>();
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            exceptions.add(MethodModelSupport.getTypeName(typeMirror));
        }
        Object var4_6 = null;
        try {
            methodModel = MethodModel.create(method.getSimpleName().toString(), MethodModelSupport.getTypeName(method.getReturnType()), "", parameters, exceptions, method.getModifiers());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        return methodModel;
    }

    public static MethodModel.Variable createVariable(CompilationController controller, VariableElement variableElement) {
        Parameters.notNull((CharSequence)"controller", (Object)controller);
        Parameters.notNull((CharSequence)"variableElement", (Object)variableElement);
        return MethodModel.Variable.create(MethodModelSupport.getTypeName(variableElement.asType()), variableElement.getSimpleName().toString(), variableElement.getModifiers().contains((Object)Modifier.FINAL));
    }

    public static MethodTree createMethodTree(WorkingCopy workingCopy, MethodModel methodModel) {
        return MethodModelSupport.createMethodTree(workingCopy, methodModel, false);
    }

    /*
     * WARNING - void declaration
     */
    public static MethodTree createMethodTree(WorkingCopy workingCopy, MethodModel methodModel, boolean generateDefaultBody) {
        void var6_11;
        Parameters.notNull((CharSequence)"workingCopy", (Object)workingCopy);
        Parameters.notNull((CharSequence)"methodModel", (Object)methodModel);
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ArrayList<VariableTree> paramsList = new ArrayList<VariableTree>();
        if (methodModel.getParameters() != null) {
            for (MethodModel.Variable variable : methodModel.getParameters()) {
                VariableTree variableTree = treeMaker.Variable(treeMaker.Modifiers(variable.getFinalModifier() ? Collections.singleton(Modifier.FINAL) : Collections.emptySet()), (CharSequence)variable.getName(), MethodModelSupport.getTypeTree(workingCopy, variable.getType()), null);
                paramsList.add(variableTree);
            }
        }
        ArrayList<ExpressionTree> throwsList = new ArrayList<ExpressionTree>();
        for (String exceptionName : methodModel.getExceptions()) {
            throwsList.add(MethodModelSupport.createQualIdent(workingCopy, exceptionName));
        }
        String body = methodModel.getBody();
        if (generateDefaultBody && (body == null || "".equals(body.trim()))) {
            String generatedBody = MethodModelSupport.getDefaultReturnValue(workingCopy, methodModel.getReturnType());
            String string = body = generatedBody == null ? "" : "return " + generatedBody + ";";
        }
        if (body == null) {
            MethodTree methodTree = treeMaker.Method(treeMaker.Modifiers(methodModel.getModifiers()), (CharSequence)methodModel.getName(), MethodModelSupport.getTypeTree(workingCopy, methodModel.getReturnType()), Collections.emptyList(), paramsList, throwsList, (BlockTree)null, null);
        } else {
            MethodTree methodTree = treeMaker.Method(treeMaker.Modifiers(methodModel.getModifiers()), (CharSequence)methodModel.getName(), MethodModelSupport.getTypeTree(workingCopy, methodModel.getReturnType()), Collections.emptyList(), paramsList, throwsList, "{" + body + "}", null);
        }
        if (workingCopy.getSourceVersion().compareTo(SourceVersion.RELEASE_5) >= 0) {
            GenerationUtils genUtils = GenerationUtils.newInstance(workingCopy);
            ArrayList<AnnotationTree> annotationList = new ArrayList<AnnotationTree>();
            for (MethodModel.Annotation annotation : methodModel.getAnnotations()) {
                AnnotationTree annotationTree = null;
                if (annotation.getArguments() == null) {
                    annotationTree = genUtils.createAnnotation(annotation.getType());
                } else {
                    ArrayList<ExpressionTree> annotationArgs = new ArrayList<ExpressionTree>();
                    for (Map.Entry<String, Object> pairs : annotation.getArguments().entrySet()) {
                        annotationArgs.add(genUtils.createAnnotationArgument(pairs.getKey(), pairs.getValue()));
                    }
                    annotationTree = genUtils.createAnnotation(annotation.getType(), annotationArgs);
                }
                annotationList.add(annotationTree);
            }
            for (AnnotationTree annotationTree : annotationList) {
                MethodTree methodTree = genUtils.addAnnotation((MethodTree)var6_11, annotationTree);
            }
        }
        return (MethodTree)GeneratorUtilities.get((WorkingCopy)workingCopy).importFQNs((Tree)var6_11);
    }

    public static boolean isSameMethod(CompilationController controller, ExecutableElement method, MethodModel methodModel) {
        Parameters.notNull((CharSequence)"compilationInfo", (Object)controller);
        Parameters.notNull((CharSequence)"method", (Object)method);
        Parameters.notNull((CharSequence)"methodModel", (Object)methodModel);
        if (!method.getSimpleName().contentEquals(methodModel.getName())) {
            return false;
        }
        List<? extends VariableElement> methodParams = method.getParameters();
        if (methodParams.size() != methodModel.getParameters().size()) {
            return false;
        }
        for (int i = 0; i < methodParams.size(); ++i) {
            MethodModel.Variable variable;
            VariableElement variableElement = methodParams.get(i);
            String variableElementType = MethodModelSupport.getTypeName(variableElement.asType());
            if (variableElementType.equals((variable = methodModel.getParameters().get(i)).getType())) continue;
            return false;
        }
        return true;
    }

    public static String getDefaultReturnValue(WorkingCopy workingCopy, String typeName) {
        if ("boolean".equals(typeName)) {
            return "false";
        }
        if ("byte".equals(typeName)) {
            return "0";
        }
        if ("short".equals(typeName)) {
            return "0";
        }
        if ("int".equals(typeName)) {
            return "0";
        }
        if ("long".equals(typeName)) {
            return "0L";
        }
        if ("char".equals(typeName)) {
            return "'c'";
        }
        if ("float".equals(typeName)) {
            return "0.0f";
        }
        if ("double".equals(typeName)) {
            return "0.0d";
        }
        if ("void".equals(typeName)) {
            return null;
        }
        return "null";
    }

    private static Tree getTypeTree(WorkingCopy workingCopy, String typeName) {
        TreeMaker make = workingCopy.getTreeMaker();
        TypeKind primitiveTypeKind = null;
        if ("boolean".equals(typeName)) {
            primitiveTypeKind = TypeKind.BOOLEAN;
        } else if ("byte".equals(typeName)) {
            primitiveTypeKind = TypeKind.BYTE;
        } else if ("short".equals(typeName)) {
            primitiveTypeKind = TypeKind.SHORT;
        } else if ("int".equals(typeName)) {
            primitiveTypeKind = TypeKind.INT;
        } else if ("long".equals(typeName)) {
            primitiveTypeKind = TypeKind.LONG;
        } else if ("char".equals(typeName)) {
            primitiveTypeKind = TypeKind.CHAR;
        } else if ("float".equals(typeName)) {
            primitiveTypeKind = TypeKind.FLOAT;
        } else if ("double".equals(typeName)) {
            primitiveTypeKind = TypeKind.DOUBLE;
        } else if ("void".equals(typeName)) {
            primitiveTypeKind = TypeKind.VOID;
        }
        if (primitiveTypeKind != null) {
            return make.PrimitiveType(primitiveTypeKind);
        }
        return MethodModelSupport.createQualIdent(workingCopy, typeName);
    }

    private static ExpressionTree createQualIdent(WorkingCopy workingCopy, String typeName) {
        TypeElement typeElement = workingCopy.getElements().getTypeElement(typeName);
        if (typeElement == null && (typeElement = workingCopy.getElements().getTypeElement("java.lang." + typeName)) == null) {
            return workingCopy.getTreeMaker().Identifier((CharSequence)typeName);
        }
        return workingCopy.getTreeMaker().QualIdent((Element)typeElement);
    }

    static String getTypeName(TypeMirror typeMirror) {
        CharSequence name = MethodModelSupport.getTypeName(typeMirror, true, false);
        return name.toString();
    }

    private static CharSequence getTypeName(TypeMirror type, boolean fqn, boolean varArg) {
        if (type == null) {
            return "";
        }
        return (CharSequence)new TypeNameVisitor(varArg).visit(type, fqn);
    }

    private static class TypeNameVisitor
    extends SimpleTypeVisitor6<StringBuilder, Boolean> {
        private boolean varArg;
        private boolean insideCapturedWildcard = false;

        private TypeNameVisitor(boolean varArg) {
            super(new StringBuilder());
            this.varArg = varArg;
        }

        @Override
        public StringBuilder defaultAction(TypeMirror t, Boolean p) {
            return ((StringBuilder)this.DEFAULT_VALUE).append(t);
        }

        @Override
        public StringBuilder visitDeclared(DeclaredType t, Boolean p) {
            Element e = t.asElement();
            if (e instanceof TypeElement) {
                TypeElement te = (TypeElement)e;
                ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? te.getQualifiedName() : te.getSimpleName()).toString());
                Iterator<? extends TypeMirror> it = t.getTypeArguments().iterator();
                if (it.hasNext()) {
                    ((StringBuilder)this.DEFAULT_VALUE).append("<");
                    while (it.hasNext()) {
                        this.visit(it.next(), p);
                        if (!it.hasNext()) continue;
                        ((StringBuilder)this.DEFAULT_VALUE).append(", ");
                    }
                    ((StringBuilder)this.DEFAULT_VALUE).append(">");
                }
                return (StringBuilder)this.DEFAULT_VALUE;
            }
            return ((StringBuilder)this.DEFAULT_VALUE).append(MethodModelSupport.UNKNOWN);
        }

        @Override
        public StringBuilder visitArray(ArrayType t, Boolean p) {
            boolean isVarArg = this.varArg;
            this.varArg = false;
            this.visit(t.getComponentType(), p);
            return ((StringBuilder)this.DEFAULT_VALUE).append(isVarArg ? "..." : "[]");
        }

        @Override
        public StringBuilder visitTypeVariable(TypeVariable t, Boolean p) {
            String name;
            Element e = t.asElement();
            if (e != null && !MethodModelSupport.CAPTURED_WILDCARD.equals(name = e.getSimpleName().toString())) {
                return ((StringBuilder)this.DEFAULT_VALUE).append(name);
            }
            ((StringBuilder)this.DEFAULT_VALUE).append("?");
            if (!this.insideCapturedWildcard) {
                this.insideCapturedWildcard = true;
                TypeMirror bound = t.getLowerBound();
                if (bound != null && bound.getKind() != TypeKind.NULL) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" super ");
                    this.visit(bound, p);
                } else {
                    bound = t.getUpperBound();
                    if (bound != null && bound.getKind() != TypeKind.NULL) {
                        ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                        if (bound.getKind() == TypeKind.TYPEVAR) {
                            bound = ((TypeVariable)bound).getLowerBound();
                        }
                        this.visit(bound, p);
                    }
                }
                this.insideCapturedWildcard = false;
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitWildcard(WildcardType t, Boolean p) {
            int len = ((StringBuilder)this.DEFAULT_VALUE).length();
            ((StringBuilder)this.DEFAULT_VALUE).append("?");
            TypeMirror bound = t.getSuperBound();
            if (bound == null) {
                bound = t.getExtendsBound();
                if (bound != null) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                    if (bound.getKind() == TypeKind.WILDCARD) {
                        bound = ((WildcardType)bound).getSuperBound();
                    }
                    this.visit(bound, p);
                } else if (!(len != 0 || (bound = SourceUtils.getBound((WildcardType)t)) == null || bound.getKind() == TypeKind.DECLARED && ((TypeElement)((DeclaredType)bound).asElement()).getQualifiedName().contentEquals("java.lang.Object"))) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                    this.visit(bound, p);
                }
            } else {
                ((StringBuilder)this.DEFAULT_VALUE).append(" super ");
                this.visit(bound, p);
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitError(ErrorType t, Boolean p) {
            Element e = t.asElement();
            if (e instanceof TypeElement) {
                TypeElement te = (TypeElement)e;
                return ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? te.getQualifiedName() : te.getSimpleName()).toString());
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }
    }
}

