/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.status;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.WorkingCopyInfo;
import org.netbeans.modules.mercurial.ui.status.VersioningPanel;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(persistenceType=0, preferredID="hgversioningTC")
public class HgVersioningTopComponent
extends TopComponent
implements Externalizable,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private VersioningPanel syncPanel;
    private VCSContext context;
    private String contentTitle;
    private String branchTitle;
    private long lastUpdateTimestamp;
    public static final String PREFERRED_ID = "hgversioningTC";
    private static HgVersioningTopComponent instance;
    private WorkingCopyInfo info;
    private File[] files = new File[0];

    public HgVersioningTopComponent() {
        this.putClientProperty("SlidingName", NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
        this.putClientProperty("KeepNonPersistentTCInModelWhenClosed", Boolean.TRUE);
        this.setName(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/mercurial/resources/icons/versioning-view.png"));
        this.setLayout(new BorderLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
        this.syncPanel = new VersioningPanel(this);
        this.add(this.syncPanel);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    protected void componentActivated() {
        this.updateTitle();
        this.syncPanel.focus(true);
    }

    protected void componentDeactivated() {
        this.syncPanel.focus(false);
    }

    protected void componentOpened() {
        super.componentOpened();
        this.refreshContent();
    }

    protected void componentClosed() {
        super.componentClosed();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.contentTitle);
        File[] files = this.context == null ? this.files : this.context.getRootFiles().toArray(new File[this.context.getRootFiles().size()]);
        out.writeObject(files);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.setContentTitle((String)in.readObject());
        this.files = (File[])in.readObject();
        final ArrayList<1> nodes = new ArrayList<1>(this.files.length);
        for (File file : this.files) {
            nodes.add(new AbstractNode(Children.LEAF, Lookups.singleton((Object)file)){

                public String getDisplayName() {
                    return ((File)this.getLookup().lookup(File.class)).getName();
                }
            });
        }
        this.setContext(null);
        Utils.post((Runnable)new Runnable(){
            final /* synthetic */ HgVersioningTopComponent this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    OpenProjects.getDefault().openProjects().get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
                final VCSContext ctx = VCSContext.forNodes((Node[])nodes.toArray(new Node[0]));
                EventQueue.invokeLater(new Runnable(){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        if (this.this$1.this$0.context == null) {
                            this.this$1.this$0.setContext(ctx);
                            this.this$1.this$0.performRefreshAction();
                        }
                    }
                });
            }
        });
    }

    private void refreshContent() {
        if (this.syncPanel == null) {
            return;
        }
        this.updateTitle();
        this.syncPanel.setContext(this.context);
    }

    public void setContentTitle(String contentTitle) {
        this.contentTitle = contentTitle;
        this.updateTitle();
    }

    void setBranchTitle(String branchTitle) {
        if (branchTitle == null) {
            branchTitle = NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_VersioningView_UnnamedBranchTitle");
        }
        this.branchTitle = branchTitle;
        this.updateTitle();
    }

    public void contentRefreshed() {
        this.lastUpdateTimestamp = System.currentTimeMillis();
        this.updateTitle();
    }

    private void updateTitle() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (HgVersioningTopComponent.this.contentTitle == null) {
                    HgVersioningTopComponent.this.setName(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title"));
                } else {
                    File baseFile = HgUtils.getRootFile(HgVersioningTopComponent.this.context);
                    String name = "";
                    if (baseFile != null) {
                        name = baseFile.getName();
                    }
                    if (HgVersioningTopComponent.this.branchTitle == null) {
                        HgVersioningTopComponent.this.setName(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_MultiTitle", (Object)HgVersioningTopComponent.this.contentTitle, (Object)(name.equals(HgVersioningTopComponent.this.contentTitle) ? "" : "[" + name + "]")));
                    } else {
                        HgVersioningTopComponent.this.setName(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"CTL_Versioning_TopComponent_Title_ContentBranch", (Object)HgVersioningTopComponent.this.contentTitle, (Object)(name.equals(HgVersioningTopComponent.this.contentTitle) ? "" : "[" + name + "] "), (Object)HgVersioningTopComponent.this.branchTitle));
                    }
                }
                HgVersioningTopComponent.this.setToolTipText(HgVersioningTopComponent.this.getName());
            }
        });
    }

    String getContentTitle() {
        return this.contentTitle;
    }

    public static synchronized HgVersioningTopComponent getDefault() {
        if (instance == null) {
            instance = new HgVersioningTopComponent();
        }
        return instance;
    }

    public static synchronized HgVersioningTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Mercurial.LOG.log(Level.FINE, "Cannot find hgversioningTC component. It will not be located properly in the window system.");
            return HgVersioningTopComponent.getDefault();
        }
        if (win instanceof HgVersioningTopComponent) {
            return (HgVersioningTopComponent)win;
        }
        Mercurial.LOG.log(Level.FINE, "There seem to be multiple components with the 'hgversioningTC' ID. That is a potential source of errors and unexpected behavior.");
        return HgVersioningTopComponent.getDefault();
    }

    public void performRefreshAction() {
        this.syncPanel.performRefreshAction();
    }

    public void setContext(VCSContext ctx) {
        this.syncPanel.cancelRefresh();
        if (ctx == null) {
            this.setName(NbBundle.getMessage(HgVersioningTopComponent.class, (String)"MSG_Preparing"));
            this.setEnabled(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setEnabled(true);
            this.setCursor(Cursor.getDefaultCursor());
            this.context = ctx;
            this.syncPanel.setContext(ctx);
            this.refreshBranchName();
            this.refreshContent();
        }
        this.setToolTipText(this.getName());
    }

    public boolean hasContext() {
        return this.context != null && this.context.getRootFiles().size() > 0;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (WorkingCopyInfo.PROPERTY_CURRENT_BRANCH.equals(evt.getPropertyName())) {
            this.setBranchTitle((String)evt.getNewValue());
            this.updateTitle();
        }
    }

    void refreshBranchName() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (HgVersioningTopComponent.this.info != null) {
                    HgVersioningTopComponent.this.info.removePropertyChangeListener(HgVersioningTopComponent.this);
                    HgVersioningTopComponent.this.info = null;
                }
                Set<File> repositoryRoots = HgUtils.getRepositoryRoots(HgVersioningTopComponent.this.context);
                String label = null;
                if (repositoryRoots.size() == 1) {
                    HgVersioningTopComponent.this.info = WorkingCopyInfo.getInstance(repositoryRoots.iterator().next());
                    HgVersioningTopComponent.this.info.addPropertyChangeListener(HgVersioningTopComponent.this);
                    label = HgVersioningTopComponent.this.info.getCurrentBranch();
                }
                HgVersioningTopComponent.this.setBranchTitle(label);
            }
        };
        if (EventQueue.isDispatchThread()) {
            Utils.post((Runnable)runnable);
        } else {
            runnable.run();
        }
    }
}

