/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.customizer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gradle.ProjectTrust;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.execute.RunUtils;
import org.netbeans.modules.gradle.customizer.Bundle;
import org.netbeans.modules.gradle.spi.execute.JavaRuntimeManager;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class GradleExecutionPanel
extends JPanel {
    public static final String HINT_JDK_PLATFORM = "hint.jdkPlatform";
    private Project project;
    private final JavaRuntimeManager runtimeManager;
    private final ChangeListener runtimeChangeListener = evt -> this.managedRuntimeSetup();
    private boolean readOnly = true;
    private JButton btManageRuntimes;
    private JCheckBox cbAugmentedBuild;
    private JCheckBox cbIncludeOpenProjects;
    private JComboBox<JavaRuntimeManager.JavaRuntime> cbRuntime;
    private JComboBox<TrustLevel> cbTrustLevel;
    private JSeparator jSeparator1;
    private JLabel lbAugmentedBuild;
    private JLabel lbIncludeOpenProjects;
    private JLabel lbReadOnly;
    private JLabel lbRuntime;
    private JLabel lbTrustLevel;
    private JLabel lbTrustTerms;

    public GradleExecutionPanel() {
        this.initComponents();
        this.runtimeManager = (JavaRuntimeManager)Lookup.getDefault().lookup(JavaRuntimeManager.class);
        if (this.runtimeManager == null) {
            this.cbRuntime.setToolTipText(Bundle.NO_RUNTIME_SUPPORT_HINT());
            this.btManageRuntimes.setToolTipText(Bundle.NO_RUNTIME_SUPPORT_HINT());
        } else {
            this.runtimeManager.addChangeListener(WeakListeners.change((ChangeListener)this.runtimeChangeListener, (Object)this.runtimeManager));
            this.managedRuntimeSetup();
            if (!this.runtimeManager.manageRuntimesAction().isPresent()) {
                this.btManageRuntimes.setToolTipText(Bundle.NO_RUNTIME_MANAGEMENT_HINT());
            }
        }
    }

    public GradleExecutionPanel(Project project) {
        this();
        this.project = project;
        GradleBaseProject gbp = GradleBaseProject.get(project);
        this.readOnly = gbp != null && !gbp.isRoot();
        this.lbReadOnly.setVisible(this.readOnly);
        this.lbTrustLevel.setEnabled(!this.readOnly);
        this.cbTrustLevel.setEnabled(!this.readOnly);
        this.lbTrustTerms.setEnabled(!this.readOnly);
        this.cbTrustLevel.setModel(new DefaultComboBoxModel<TrustLevel>(TrustLevel.values()));
        if (ProjectTrust.getDefault().isTrustedPermanently(project)) {
            this.cbTrustLevel.setSelectedItem((Object)TrustLevel.PERMANENT);
            this.setJavaSettingsEnabled(!this.readOnly);
        } else if (ProjectTrust.getDefault().isTrusted(project)) {
            this.cbTrustLevel.setSelectedItem((Object)TrustLevel.TEMPORARY);
            this.setJavaSettingsEnabled(!this.readOnly);
        } else {
            this.cbTrustLevel.setSelectedItem((Object)TrustLevel.NONE);
            this.setJavaSettingsEnabled(false);
        }
        this.cbRuntime.setRenderer(new RuntimeRenderer());
        this.selectRuntime(RunUtils.getActiveRuntime(project));
        this.setupCheckBox(this.cbAugmentedBuild, "augmented.build", true);
        this.setupCheckBox(this.cbIncludeOpenProjects, "include.open.projects", false);
    }

    private void selectRuntime(JavaRuntimeManager.JavaRuntime selected) {
        ComboBoxModel<JavaRuntimeManager.JavaRuntime> model = this.cbRuntime.getModel();
        if (selected == null || selected.isBroken()) {
            model.setSelectedItem(selected);
        } else {
            for (int i = 0; i < model.getSize(); ++i) {
                JavaRuntimeManager.JavaRuntime rt = (JavaRuntimeManager.JavaRuntime)model.getElementAt(i);
                if (!rt.equals(selected)) continue;
                model.setSelectedItem(model.getElementAt(i));
                break;
            }
        }
    }

    private void setupCheckBox(JCheckBox check, String property, boolean defaultValue) {
        Project root = ProjectUtils.rootOf((Project)this.project);
        GradleBaseProject gbp = GradleBaseProject.get(root);
        if (gbp != null) {
            if (gbp.getNetBeansProperty(property) != null) {
                check.setEnabled(!this.readOnly);
                check.setSelected(Boolean.parseBoolean(gbp.getNetBeansProperty(property)));
                check.setToolTipText(Bundle.COMPILE_DISABLED_HINT(property));
            } else {
                Preferences prefs = NbGradleProject.getPreferences(root, false);
                check.setSelected(prefs.getBoolean(property, defaultValue));
            }
        }
    }

    private void managedRuntimeSetup() {
        int selected = this.cbRuntime.getSelectedIndex();
        JavaRuntimeManager.JavaRuntime runtime = selected != -1 ? (JavaRuntimeManager.JavaRuntime)this.cbRuntime.getModel().getElementAt(selected) : null;
        Map availabeRuntimes = this.runtimeManager != null ? this.runtimeManager.getAvailableRuntimes() : Collections.emptyMap();
        Object[] runtimes = availabeRuntimes.values().toArray(new JavaRuntimeManager.JavaRuntime[0]);
        Arrays.sort(runtimes);
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(runtimes);
        this.cbRuntime.setModel(model);
        this.selectRuntime(runtime);
    }

    private void setJavaSettingsEnabled(boolean b) {
        boolean enableRuntime = b && this.runtimeManager != null;
        this.lbRuntime.setEnabled(enableRuntime);
        this.cbRuntime.setEnabled(enableRuntime);
        this.btManageRuntimes.setEnabled(enableRuntime && this.runtimeManager.manageRuntimesAction().isPresent());
        this.cbAugmentedBuild.setEnabled(b);
        this.lbAugmentedBuild.setEnabled(b);
        this.cbIncludeOpenProjects.setEnabled(b);
        this.lbIncludeOpenProjects.setEnabled(b);
    }

    private void initComponents() {
        this.lbRuntime = new JLabel();
        this.cbRuntime = new JComboBox();
        this.btManageRuntimes = new JButton();
        this.cbAugmentedBuild = new JCheckBox();
        this.lbAugmentedBuild = new JLabel();
        this.cbIncludeOpenProjects = new JCheckBox();
        this.lbIncludeOpenProjects = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.lbTrustLevel = new JLabel();
        this.cbTrustLevel = new JComboBox();
        this.lbTrustTerms = new JLabel();
        this.lbReadOnly = new JLabel();
        this.lbRuntime.setLabelFor(this.cbRuntime);
        Mnemonics.setLocalizedText((JLabel)this.lbRuntime, (String)NbBundle.getMessage(GradleExecutionPanel.class, (String)"GradleExecutionPanel.lbRuntime.text"));
        this.cbRuntime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GradleExecutionPanel.this.cbRuntimeActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btManageRuntimes, (String)NbBundle.getMessage(GradleExecutionPanel.class, (String)"GradleExecutionPanel.btManageRuntimes.text"));
        this.btManageRuntimes.setActionCommand(NbBundle.getMessage(GradleExecutionPanel.class, (String)"GradleExecutionPanel.btManageRuntimes.actionCommand"));
        this.btManageRuntimes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GradleExecutionPanel.this.btManageRuntimesActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbAugmentedBuild, (String)NbBundle.getMessage(GradleExecutionPanel.class, (String)"GradleExecutionPanel.cbAugmentedBuild.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbAugmentedBuild, (String)NbBundle.getMessage(GradleExecutionPanel.class, (String)"GradleExecutionPanel.lbAugmentedBuild.text"));
        this.lbAugmentedBuild.setVerticalAlignment(1);
        Mnemonics.setLocalizedText((AbstractButton)this.cbIncludeOpenProjects, (String)NbBundle.getMessage(GradleExecutionPanel.class, (String)"GradleExecutionPanel.cbIncludeOpenProjects.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbIncludeOpenProjects, (String)NbBundle.getMessage(GradleExecutionPanel.class, (String)"GradleExecutionPanel.lbIncludeOpenProjects.text"));
        this.lbIncludeOpenProjects.setVerticalAlignment(1);
        Mnemonics.setLocalizedText((JLabel)this.lbTrustLevel, (String)NbBundle.getMessage(GradleExecutionPanel.class, (String)"GradleExecutionPanel.lbTrustLevel.text"));
        this.cbTrustLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GradleExecutionPanel.this.cbTrustLevelActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbTrustTerms, (String)NbBundle.getMessage(GradleExecutionPanel.class, (String)"GradleExecutionPanel.lbTrustTerms.text"));
        this.lbTrustTerms.setVerticalAlignment(1);
        this.lbReadOnly.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/gradle/resources/info.png")));
        Mnemonics.setLocalizedText((JLabel)this.lbReadOnly, (String)NbBundle.getMessage(GradleExecutionPanel.class, (String)"GradleExecutionPanel.lbReadOnly.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.lbReadOnly)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lbTrustLevel, -2, 99, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbTrustLevel, -2, 265, -2))).addContainerGap(317, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.lbIncludeOpenProjects, -2, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.lbRuntime, -2, 99, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbRuntime, -2, 265, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btManageRuntimes).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbIncludeOpenProjects, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.lbAugmentedBuild, -2, 0, Short.MAX_VALUE)).addComponent(this.cbAugmentedBuild, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator1).addComponent(this.lbTrustTerms, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE)).addContainerGap()))));
        layout.linkSize(0, this.cbRuntime, this.cbTrustLevel);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbRuntime).addComponent(this.btManageRuntimes).addComponent(this.cbRuntime, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbAugmentedBuild).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbAugmentedBuild, -2, 36, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbIncludeOpenProjects).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbIncludeOpenProjects, -2, 56, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbTrustLevel).addComponent(this.cbTrustLevel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbTrustTerms, -2, 128, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.lbReadOnly).addContainerGap()));
    }

    private void btManageRuntimesActionPerformed(ActionEvent evt) {
        if (this.runtimeManager != null && this.runtimeManager.manageRuntimesAction().isPresent()) {
            this.runtimeManager.manageRuntimesAction().get().run();
        }
    }

    private void cbTrustLevelActionPerformed(ActionEvent evt) {
        this.setJavaSettingsEnabled(!this.readOnly && this.cbTrustLevel.getSelectedItem() != TrustLevel.NONE);
    }

    private void cbRuntimeActionPerformed(ActionEvent evt) {
        JavaRuntimeManager.JavaRuntime rt = (JavaRuntimeManager.JavaRuntime)this.cbRuntime.getSelectedItem();
        String fore = rt != null && rt.isBroken() ? "nb.errorForeground" : "ComboBox.foreground";
        this.cbRuntime.setForeground(UIManager.getColor(fore));
    }

    private void saveTrustLevel(Project project) {
        TrustLevel v = (TrustLevel)((Object)this.cbTrustLevel.getSelectedItem());
        if (v == null) {
            v = TrustLevel.NONE;
        }
        switch (v.ordinal()) {
            case 2: {
                ProjectTrust.getDefault().distrustProject(project);
                break;
            }
            case 0: {
                ProjectTrust.getDefault().trustProject(project, true);
                break;
            }
            case 1: {
                if (ProjectTrust.getDefault().isTrustedPermanently(project)) {
                    ProjectTrust.getDefault().distrustProject(project);
                }
                ProjectTrust.getDefault().trustProject(project, false);
            }
        }
    }

    private void saveJavaRuntime(Project project) {
        RunUtils.setActiveRuntime(project, (JavaRuntimeManager.JavaRuntime)this.cbRuntime.getSelectedItem());
    }

    private void saveCheckBox(JCheckBox check, String property) {
        GradleBaseProject gbp;
        GradleBaseProject gradleBaseProject = gbp = this.project != null ? GradleBaseProject.get(this.project) : null;
        if (gbp != null && gbp.getNetBeansProperty(property) == null) {
            Preferences prefs = NbGradleProject.getPreferences(this.project, false);
            prefs.putBoolean(property, check.isSelected());
        }
    }

    void save() {
        if (this.project != null) {
            this.saveTrustLevel(this.project);
            this.saveJavaRuntime(this.project);
            this.saveCheckBox(this.cbAugmentedBuild, "augmented.build");
            this.saveCheckBox(this.cbIncludeOpenProjects, "include.open.projects");
        }
    }

    static enum TrustLevel {
        PERMANENT,
        TEMPORARY,
        NONE;


        public String toString() {
            return NbBundle.getMessage(GradleExecutionPanel.class, (String)("GradleExecutionPanel.cbTrustLevel." + this.name()));
        }
    }

    private static class RuntimeRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        private RuntimeRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setOpaque(true);
            if (value instanceof JavaRuntimeManager.JavaRuntime) {
                JavaRuntimeManager.JavaRuntime rt = (JavaRuntimeManager.JavaRuntime)value;
                this.setText(rt.getDisplayName());
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                if (rt.isBroken()) {
                    this.setText(Bundle.LBL_MissingRuntime(value));
                }
            } else if (value == null) {
                this.setText("");
            }
            return this;
        }
    }
}

