/*
 * Decompiled with CFR 0.152.
 */
package airsquared.JMacNotification;

import airsquared.JMacNotification.NSObject;
import airsquared.JMacNotification.natives.NSTypes;
import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;

public class NSArray
implements NSObject {
    private Pointer pointer;

    public NSArray() {
        this.pointer = NSTypes.newNSMutableArray();
    }

    public NSArray(Pointer p) {
        this.pointer = p;
    }

    public static NSArray fromPointerList(List<Pointer> list) {
        NSArray array = new NSArray();
        list.forEach(array::add);
        return array;
    }

    public static NSArray fromNSObjectList(List<NSObject> list) {
        NSArray array = new NSArray();
        list.forEach(array::add);
        return array;
    }

    public ArrayList<Pointer> toList() {
        ArrayList<Pointer> arrayList = new ArrayList<Pointer>();
        for (int i = 0; i < this.size(); ++i) {
            arrayList.add(this.get(i));
        }
        return arrayList;
    }

    public int size() {
        return NSTypes.count(this.pointer);
    }

    public boolean contains(Pointer nsObject) {
        return NSTypes.containsObject(this.pointer, nsObject);
    }

    public boolean contains(NSObject object) {
        return this.contains(object.getPointer());
    }

    public int indexOf(Pointer nsObject) {
        return NSTypes.indexOfObject(this.pointer, nsObject);
    }

    public int indexOf(NSObject object) {
        return this.indexOf(object.getPointer());
    }

    public void add(Pointer nsObject) {
        NSTypes.addObject(this.pointer, nsObject);
    }

    public void add(NSObject object) {
        this.add(object.getPointer());
    }

    public void add(int index, Pointer nsObject) {
        NSTypes.insertObjectAtIndex(this.pointer, nsObject, index);
    }

    public void add(int index, NSObject object) {
        this.add(index, object.getPointer());
    }

    public void set(int index, Pointer nsObject) {
        NSTypes.replaceObjectAtIndex(this.pointer, index, nsObject);
    }

    public void set(int index, NSObject object) {
        this.set(index, object.getPointer());
    }

    public Pointer get(int index) {
        return NSTypes.objectAtIndex(this.pointer, index);
    }

    public void remove(Pointer nsObject) {
        NSTypes.removeObject(this.pointer, nsObject);
    }

    public void remove(NSObject object) {
        this.remove(object.getPointer());
    }

    public void remove(int index) {
        NSTypes.removeObjectAtIndex(this.pointer, index);
    }

    public void clear() {
        NSTypes.removeAllObjects(this.pointer);
    }

    @Override
    public Pointer getPointer() {
        return this.pointer;
    }

    @Override
    public String nativeType() {
        return "NSArray";
    }

    public boolean equals(Object obj) {
        if (obj instanceof Pointer) {
            return NSTypes.isEqual(this.pointer, (Pointer)obj);
        }
        if (obj instanceof NSObject) {
            return NSTypes.isEqual(this.pointer, ((NSObject)obj).getPointer());
        }
        return false;
    }

    public int hashCode() {
        return NSTypes.hash(this.pointer);
    }
}

