/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.swingx.ui;

import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXTipOfTheDay;
import org.jdesktop.swingx.plaf.basic.BasicTipOfTheDayUI;

public class FlatTipOfTheDayUI
extends BasicTipOfTheDayUI {
    public static ComponentUI createUI(JComponent c) {
        return new FlatTipOfTheDayUI((JXTipOfTheDay)c);
    }

    public FlatTipOfTheDayUI(JXTipOfTheDay tipPane) {
        super(tipPane);
    }

    protected void installComponents() {
        this.tipPane.removeAll();
        super.installComponents();
        Insets tipAreaInsets = UIManager.getInsets("TipOfTheDay.tipAreaInsets");
        if (tipAreaInsets != null) {
            this.tipArea.setBorder(FlatUIUtils.nonUIResource((Border)new FlatEmptyBorder(tipAreaInsets)));
        }
    }

    protected void uninstallComponents() {
        super.uninstallComponents();
        this.tipPane.removeAll();
    }

    protected PropertyChangeListener createChangeListener() {
        PropertyChangeListener superListener = super.createChangeListener();
        return e -> {
            superListener.propertyChange(e);
            if ("model".equals(e.getPropertyName())) {
                this.showCurrentTip();
            }
        };
    }

    public Dimension getPreferredSize(JComponent c) {
        return UIScale.scale((Dimension)super.getPreferredSize(c));
    }

    protected void showCurrentTip() {
        super.showCurrentTip();
        if (this.currentTipComponent instanceof JScrollPane) {
            Component view;
            JScrollPane scrollPane = (JScrollPane)this.currentTipComponent;
            if (scrollPane.getBorder() == null) {
                scrollPane.setBorder(BorderFactory.createEmptyBorder());
            }
            if ((view = scrollPane.getViewport().getView()) instanceof JTextComponent && ((JTextComponent)view).getBorder() == null) {
                ((JTextComponent)view).setBorder(BorderFactory.createEmptyBorder());
            }
        }
    }
}

