/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.TestTools;
import org.languagetool.rules.Example;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.UppercaseSentenceStartRule;

public class UppercaseSentenceStartRuleTest {
    private final UppercaseSentenceStartRule rule = new UppercaseSentenceStartRule(TestTools.getEnglishMessages(), TestTools.getDemoLanguage(), Example.wrong((String)"<marker>a</marker> sentence."), Example.fixed((String)"<marker>A</marker> sentence."));
    private final JLanguageTool lt = new JLanguageTool(TestTools.getDemoLanguage());

    @Test
    public void testRule() throws IOException {
        this.assertGood("this");
        this.assertGood("a) This is a test sentence.");
        this.assertGood("iv. This is a test sentence...");
        this.assertGood("\"iv. This is a test sentence...\"");
        this.assertGood("\u00bbiv. This is a test sentence...");
        this.assertGood("This");
        this.assertGood("This is");
        this.assertGood("This is a test sentence");
        this.assertGood("");
        this.assertGood("http://www.languagetool.org");
        this.assertGood("eBay can be at sentence start in lowercase.");
        this.assertGood("\u00bfEsto es una pregunta?");
        this.assertGood("\u00bfEsto es una pregunta?, \u00bfy esto?");
        this.assertGood("\u00f8 This is a test sentence with a wrong bullet character.");
        RuleMatch[] matches = this.rule.match(this.lt.analyzeText("this is a test sentence."));
        Assert.assertEquals((long)1L, (long)matches.length);
        Assert.assertEquals((long)0L, (long)matches[0].getFromPos());
        Assert.assertEquals((long)4L, (long)matches[0].getToPos());
        RuleMatch[] matches2 = this.rule.match(this.lt.analyzeText("this!"));
        Assert.assertEquals((long)1L, (long)matches2.length);
        Assert.assertEquals((long)0L, (long)matches2[0].getFromPos());
        Assert.assertEquals((long)4L, (long)matches2[0].getToPos());
        RuleMatch[] matches3 = this.rule.match(this.lt.analyzeText("'this is a sentence'."));
        Assert.assertEquals((long)1L, (long)matches3.length);
        RuleMatch[] matches4 = this.rule.match(this.lt.analyzeText("\"this is a sentence.\""));
        Assert.assertEquals((long)1L, (long)matches4.length);
        RuleMatch[] matches5 = this.rule.match(this.lt.analyzeText("\u201ethis is a sentence."));
        Assert.assertEquals((long)1L, (long)matches5.length);
        RuleMatch[] matches6 = this.rule.match(this.lt.analyzeText("\u00abthis is a sentence."));
        Assert.assertEquals((long)1L, (long)matches6.length);
        RuleMatch[] matches7 = this.rule.match(this.lt.analyzeText("\u2018this is a sentence."));
        Assert.assertEquals((long)1L, (long)matches7.length);
        RuleMatch[] matches8 = this.rule.match(this.lt.analyzeText("\u00bfesto es una pregunta?"));
        Assert.assertEquals((long)1L, (long)matches8.length);
        RuleMatch[] matches9 = this.rule.match(this.lt.analyzeText("\u00bfEsto es una pregunta? \u00bfy esto?"));
        Assert.assertEquals((long)1L, (long)matches9.length);
    }

    private void assertGood(String s) throws IOException {
        List analyzedSentences = this.lt.analyzeText(s);
        RuleMatch[] matches = this.rule.match(analyzedSentences);
        Assert.assertEquals((long)0L, (long)matches.length);
    }
}

