/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.EDT;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public abstract class EdtInvocationManager {
    private static final AtomicReference<EdtInvocationManager> ourInstance = new AtomicReference();

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            EdtInvocationManager.$$$reportNull$$$0(0);
        }
        if (EDT.isCurrentThreadEdt()) {
            runnable.run();
        } else {
            EdtInvocationManager.getInstance().invokeLater(runnable);
        }
    }

    public abstract void invokeLater(@NotNull Runnable var1);

    public abstract void invokeAndWait(@NotNull Runnable var1) throws InvocationTargetException, InterruptedException;

    @NotNull
    public static EdtInvocationManager getInstance() {
        EdtInvocationManager result2 = ourInstance.get();
        if (result2 == null && !ourInstance.compareAndSet(null, result2 = new SwingEdtInvocationManager())) {
            result2 = ourInstance.get();
        }
        EdtInvocationManager edtInvocationManager = result2;
        if (edtInvocationManager == null) {
            EdtInvocationManager.$$$reportNull$$$0(1);
        }
        return edtInvocationManager;
    }

    public static void invokeAndWaitIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            EdtInvocationManager.$$$reportNull$$$0(3);
        }
        if (EDT.isCurrentThreadEdt()) {
            runnable.run();
        } else {
            try {
                EdtInvocationManager.getInstance().invokeAndWait(runnable);
            }
            catch (Exception e2) {
                Logger.getInstance(EdtInvocationManager.class).error(e2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/EdtInvocationManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtInvocationManager";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/EdtInvocationManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setEdtInvocationManager";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWaitIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SwingEdtInvocationManager
    extends EdtInvocationManager {
        @Override
        public void invokeLater(@NotNull Runnable task) {
            if (task == null) {
                SwingEdtInvocationManager.$$$reportNull$$$0(0);
            }
            EventQueue.invokeLater(task);
        }

        @Override
        public void invokeAndWait(@NotNull Runnable task) throws InvocationTargetException, InterruptedException {
            if (task == null) {
                SwingEdtInvocationManager.$$$reportNull$$$0(1);
            }
            EventQueue.invokeAndWait(task);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "task";
            objectArray2[1] = "com/intellij/util/ui/EdtInvocationManager$SwingEdtInvocationManager";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invokeLater";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invokeAndWait";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

