/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.entities;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.infinispan.api.annotations.indexing.Basic;
import org.infinispan.api.annotations.indexing.Indexed;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.common.util.Time;
import org.keycloak.models.OfflineUserSessionModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;

@ProtoTypeId(value=65605)
@Indexed
public class RemoteUserSessionEntity {
    private final String userSessionId;
    private String realmId;
    private String userId;
    private String brokerSessionId;
    private String brokerUserId;
    private String loginUsername;
    private String ipAddress;
    private String authMethod;
    private boolean rememberMe;
    private int started;
    private int lastSessionRefresh;
    private UserSessionModel.State state;
    private Map<String, String> notes;

    private RemoteUserSessionEntity(String userSessionId) {
        this.userSessionId = Objects.requireNonNull(userSessionId);
    }

    public static RemoteUserSessionEntity create(String id, RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        RemoteUserSessionEntity e = new RemoteUserSessionEntity(id);
        e.restart(realm.getId(), user.getId(), loginUsername, ipAddress, authMethod, rememberMe, brokerSessionId, brokerUserId);
        return e;
    }

    public static RemoteUserSessionEntity createFromModel(UserSessionModel model) {
        String userId;
        String loginUsername = null;
        if (model instanceof OfflineUserSessionModel) {
            OfflineUserSessionModel offline = (OfflineUserSessionModel)model;
            userId = offline.getUserId();
        } else {
            userId = model.getUser().getId();
            loginUsername = model.getLoginUsername();
        }
        RemoteUserSessionEntity e = new RemoteUserSessionEntity(model.getId());
        e.restart(model.getRealm().getId(), userId, loginUsername, model.getIpAddress(), model.getAuthMethod(), model.isRememberMe(), model.getBrokerSessionId(), model.getBrokerUserId());
        Map notes = model.getNotes();
        if (notes != null && !notes.isEmpty()) {
            e.notes = new HashMap<String, String>(notes);
        }
        e.state = model.getState();
        return e;
    }

    public static RemoteUserSessionEntity mockEntity(String id, String realmId, String userId) {
        return RemoteUserSessionEntity.mockEntity(id, realmId, userId, null, null);
    }

    public static RemoteUserSessionEntity mockEntity(String id, String realmId, String userId, String brokerSessionId, String brokerUserId) {
        RemoteUserSessionEntity e = new RemoteUserSessionEntity(id);
        e.realmId = realmId;
        e.userId = userId;
        e.brokerSessionId = brokerSessionId;
        e.brokerUserId = brokerUserId;
        return e;
    }

    @ProtoFactory
    static RemoteUserSessionEntity protoFactory(String userSessionId, String authMethod, String brokerSessionId, String brokerUserId, String ipAddress, int lastSessionRefresh, String loginUsername, Map<String, String> notes, String realmId, boolean rememberMe, int started, UserSessionModel.State state, String userId) {
        RemoteUserSessionEntity e = new RemoteUserSessionEntity(userSessionId);
        e.applyState(authMethod, brokerSessionId, brokerUserId, ipAddress, lastSessionRefresh, loginUsername, notes, realmId, rememberMe, started, state, userId);
        return e;
    }

    @ProtoField(value=1)
    @Basic(sortable=true)
    public String getUserSessionId() {
        return this.userSessionId;
    }

    @ProtoField(value=2)
    public String getAuthMethod() {
        return this.authMethod;
    }

    @ProtoField(value=3)
    @Basic
    public String getBrokerSessionId() {
        return this.brokerSessionId;
    }

    @ProtoField(value=4)
    @Basic
    public String getBrokerUserId() {
        return this.brokerUserId;
    }

    @ProtoField(value=5)
    public String getIpAddress() {
        return this.ipAddress;
    }

    @ProtoField(value=6)
    public int getLastSessionRefresh() {
        return this.lastSessionRefresh;
    }

    public void setLastSessionRefresh(int lastSessionRefresh) {
        this.lastSessionRefresh = Math.max(this.lastSessionRefresh, lastSessionRefresh);
    }

    @ProtoField(value=7)
    public String getLoginUsername() {
        return this.loginUsername;
    }

    @ProtoField(value=8, mapImplementation=HashMap.class)
    public Map<String, String> getNotes() {
        return this.notes;
    }

    public void setNotes(Map<String, String> notes) {
        this.notes = notes;
    }

    @ProtoField(value=9)
    @Basic
    public String getRealmId() {
        return this.realmId;
    }

    @ProtoField(value=10)
    public boolean isRememberMe() {
        return this.rememberMe;
    }

    @ProtoField(value=11)
    public int getStarted() {
        return this.started;
    }

    @ProtoField(value=12)
    public UserSessionModel.State getState() {
        return this.state;
    }

    public void setState(UserSessionModel.State state) {
        this.state = state;
    }

    @ProtoField(value=13)
    @Basic
    public String getUserId() {
        return this.userId;
    }

    public void restart(String realmId, String userId, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        int currentTime = Time.currentTime();
        this.applyState(authMethod, brokerSessionId, brokerUserId, ipAddress, currentTime, loginUsername, null, realmId, rememberMe, currentTime, null, userId);
    }

    private void applyState(String authMethod, String brokerSessionId, String brokerUserId, String ipAddress, int lastSessionRefresh, String loginUsername, Map<String, String> notes, String realmId, boolean rememberMe, int started, UserSessionModel.State state, String userId) {
        this.realmId = realmId;
        this.userId = userId;
        this.loginUsername = loginUsername;
        this.ipAddress = ipAddress;
        this.authMethod = authMethod;
        this.rememberMe = rememberMe;
        this.brokerSessionId = brokerSessionId;
        this.brokerUserId = brokerUserId;
        this.started = started;
        this.lastSessionRefresh = lastSessionRefresh;
        this.notes = notes;
        this.state = state;
    }
}

