/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.desc;

import io.quarkus.gizmo2.MethodTyped;
import io.quarkus.gizmo2.desc.MemberDesc;
import io.quarkus.gizmo2.impl.ConstructorDescImpl;
import io.quarkus.gizmo2.impl.Util;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ConstructorDesc
extends MemberDesc,
MethodTyped {
    public static ConstructorDesc of(ClassDesc owner, MethodTypeDesc type) {
        return new ConstructorDescImpl(owner, type);
    }

    public static ConstructorDesc of(ClassDesc owner) {
        return ConstructorDesc.of(owner, MethodTypeDesc.of(ConstantDescs.CD_void, new ClassDesc[0]));
    }

    public static ConstructorDesc of(ClassDesc owner, Class<?> ... paramTypes) {
        ClassDesc[] params = (ClassDesc[])Stream.of(paramTypes).map(Util::classDesc).toArray(ClassDesc[]::new);
        return ConstructorDesc.of(owner, MethodTypeDesc.of(ConstantDescs.CD_void, params));
    }

    public static ConstructorDesc of(ClassDesc owner, ClassDesc ... paramTypes) {
        return ConstructorDesc.of(owner, MethodTypeDesc.of(ConstantDescs.CD_void, paramTypes));
    }

    public static ConstructorDesc of(ClassDesc owner, List<ClassDesc> paramTypes) {
        return ConstructorDesc.of(owner, MethodTypeDesc.of(ConstantDescs.CD_void, (ClassDesc[])paramTypes.toArray(ClassDesc[]::new)));
    }

    public static ConstructorDesc of(Class<?> owner, MethodTypeDesc type) {
        return ConstructorDesc.of(Util.classDesc(owner), type);
    }

    public static ConstructorDesc of(Class<?> owner, MethodType type) {
        return ConstructorDesc.of(owner, type.describeConstable().orElseThrow(IllegalArgumentException::new));
    }

    public static ConstructorDesc of(Class<?> owner, Class<?> ... paramTypes) {
        return ConstructorDesc.of(owner, MethodType.methodType(Void.TYPE, paramTypes));
    }

    public static ConstructorDesc of(Class<?> owner, List<Class<?>> paramTypes) {
        return ConstructorDesc.of(owner, MethodType.methodType(Void.TYPE, paramTypes));
    }

    public static ConstructorDesc of(Constructor<?> ctor) {
        return ConstructorDesc.of(ctor.getDeclaringClass(), ctor.getParameterTypes());
    }

    @Override
    public MethodTypeDesc type();
}

