/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.timeline;

import java.util.Iterator;
import java.util.Objects;
import org.apache.kafka.timeline.Delta;
import org.apache.kafka.timeline.Revertable;
import org.apache.kafka.timeline.Snapshot;
import org.apache.kafka.timeline.SnapshotRegistry;

public final class TimelineObject<T>
implements Revertable {
    private final SnapshotRegistry snapshotRegistry;
    private final T initialValue;
    private T value;

    public TimelineObject(SnapshotRegistry snapshotRegistry, T initialValue) {
        Objects.requireNonNull(initialValue);
        this.snapshotRegistry = snapshotRegistry;
        this.initialValue = initialValue;
        this.value = initialValue;
        snapshotRegistry.register(this);
    }

    public T get() {
        return this.value;
    }

    public T get(long epoch) {
        if (epoch == Long.MAX_VALUE) {
            return this.value;
        }
        Iterator<Snapshot> iterator = this.snapshotRegistry.iterator(epoch);
        while (iterator.hasNext()) {
            Snapshot snapshot = iterator.next();
            ObjectContainer container = (ObjectContainer)snapshot.getDelta(this);
            if (container == null) continue;
            return container.value();
        }
        return this.value;
    }

    public void set(T newValue) {
        Snapshot snapshot;
        ObjectContainer<T> prevContainer;
        Objects.requireNonNull(newValue);
        Iterator<Snapshot> iterator = this.snapshotRegistry.reverseIterator();
        if (iterator.hasNext() && (prevContainer = (ObjectContainer<T>)(snapshot = iterator.next()).getDelta(this)) == null) {
            prevContainer = new ObjectContainer<T>(this.initialValue);
            snapshot.setDelta(this, prevContainer);
            prevContainer.setValue(this.value);
        }
        this.value = newValue;
    }

    @Override
    public void executeRevert(long targetEpoch, Delta delta) {
        ObjectContainer container = (ObjectContainer)delta;
        this.value = container.value();
    }

    @Override
    public void reset() {
        this.set(this.initialValue);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TimelineObject)) {
            return false;
        }
        TimelineObject other = (TimelineObject)o;
        return this.value.equals(other.value);
    }

    public String toString() {
        return this.value.toString();
    }

    static class ObjectContainer<T>
    implements Delta {
        private T value;

        ObjectContainer(T initialValue) {
            this.value = initialValue;
        }

        T value() {
            return this.value;
        }

        void setValue(T value) {
            this.value = value;
        }

        @Override
        public void mergeFrom(long destinationEpoch, Delta delta) {
        }
    }
}

