/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.sourceSetArtifactIndex;

import com.intellij.gradle.toolingExtension.impl.model.sourceSetArtifactIndex.GradleSourceSetArtifactBuildRequest;
import com.intellij.gradle.toolingExtension.impl.model.sourceSetArtifactIndex.GradleSourceSetArtifactIndex;
import com.intellij.gradle.toolingExtension.impl.model.sourceSetArtifactIndex.GradleSourceSetArtifactModel;
import com.intellij.gradle.toolingExtension.impl.util.GradleTaskUtil;
import com.intellij.gradle.toolingExtension.impl.util.javaPluginUtil.JavaPluginUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Objects;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.tooling.AbstractModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;

public class GradleSourceSetArtifactIndexBuilder
extends AbstractModelBuilderService {
    public boolean canBuild(String modelName) {
        return GradleSourceSetArtifactBuildRequest.class.getName().equals(modelName);
    }

    public Object buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context) {
        if (modelName == null) {
            GradleSourceSetArtifactIndexBuilder.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GradleSourceSetArtifactIndexBuilder.$$$reportNull$$$0(1);
        }
        if (context == null) {
            GradleSourceSetArtifactIndexBuilder.$$$reportNull$$$0(2);
        }
        GradleSourceSetArtifactModel sourceSetArtifactModel = new GradleSourceSetArtifactModel();
        SourceSetContainer sourceSetContainer = JavaPluginUtil.getSourceSetContainer(project);
        if (sourceSetContainer != null && !sourceSetContainer.isEmpty()) {
            HashMap<String, SourceSet> sourceSetArtifactMap = new HashMap<String, SourceSet>();
            HashMap<String, String> sourceSetOutputArtifactMap = new HashMap<String, String>();
            for (SourceSet sourceSet : sourceSetContainer) {
                Task task = (Task)project.getTasks().findByName(sourceSet.getJarTaskName());
                if (!(task instanceof AbstractArchiveTask)) continue;
                File archiveFile = GradleTaskUtil.getTaskArchiveFile((AbstractArchiveTask)task);
                sourceSetArtifactMap.put(archiveFile.getPath(), sourceSet);
                for (File file : sourceSet.getOutput().getClassesDirs().getFiles()) {
                    sourceSetOutputArtifactMap.put(file.getPath(), archiveFile.getPath());
                }
                File resourcesDir = Objects.requireNonNull(sourceSet.getOutput().getResourcesDir());
                sourceSetOutputArtifactMap.put(resourcesDir.getPath(), archiveFile.getPath());
            }
            sourceSetArtifactModel.setSourceSetArtifactMap(sourceSetArtifactMap);
            sourceSetArtifactModel.setSourceSetOutputArtifactMap(sourceSetOutputArtifactMap);
        }
        GradleSourceSetArtifactIndex.getInstance(context).setSourceSetArtifactModel(project, sourceSetArtifactModel);
        return null;
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        if (modelName == null) {
            GradleSourceSetArtifactIndexBuilder.$$$reportNull$$$0(3);
        }
        if (project == null) {
            GradleSourceSetArtifactIndexBuilder.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GradleSourceSetArtifactIndexBuilder.$$$reportNull$$$0(5);
        }
        if (exception == null) {
            GradleSourceSetArtifactIndexBuilder.$$$reportNull$$$0(6);
        }
        GradleSourceSetArtifactIndex.getInstance(context).markSourceSetArtifactModelAsError(project);
        context.getMessageReporter().createMessage().withGroup("gradle.sourceSetArtifactIndex.group").withKind(Message.Kind.ERROR).withTitle("Source set artifact index building failure").withException(exception).reportMessage(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelName";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
        }
        objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/model/sourceSetArtifactIndex/GradleSourceSetArtifactIndexBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildAll";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "reportErrorMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

