/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.util;

import java.awt.AWTException;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;

public class RobotFactory {
    @Nonnull
    public Robot newRobotInPrimaryScreen() throws AWTException {
        return new Robot();
    }

    @Nonnull
    public Robot newRobotInLeftScreen() throws AWTException {
        int lowestX = Integer.MAX_VALUE;
        GraphicsDevice lowestScreen = null;
        for (GraphicsDevice screen : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            if (screen.getDefaultConfiguration().getBounds().x >= lowestX) continue;
            lowestX = screen.getDefaultConfiguration().getBounds().x;
            lowestScreen = screen;
        }
        return new Robot(lowestScreen);
    }
}

