/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.sourceforge.jnlp.AssociationDesc;
import net.sourceforge.jnlp.IconDesc;
import net.sourceforge.jnlp.RelatedContentDesc;
import net.sourceforge.jnlp.ShortcutDesc;

public class InformationDesc {
    public static final Object ONE_LINE = "one-line";
    public static final Object SHORT = "short";
    public static final Object TOOLTIP = "tooltip";
    public static final Object DEFAULT = "default";
    private final Locale[] locales;
    private List<Object> info;
    final boolean strict;

    public InformationDesc(Locale[] locales, boolean strict) {
        this.locales = locales;
        this.strict = strict;
    }

    InformationDesc(Locale[] locales) {
        this(locales, false);
    }

    public String getTitle() {
        return (String)this.getItem("title");
    }

    public String getVendor() {
        return (String)this.getItem("vendor");
    }

    public URL getHomepage() {
        return (URL)this.getItem("homepage");
    }

    public String getDescription() {
        String result = this.getDescription(DEFAULT);
        if (result == null) {
            result = this.getDescription(ONE_LINE);
        }
        if (result == null) {
            result = this.getDescription(SHORT);
        }
        if (result == null) {
            result = this.getDescription(TOOLTIP);
        }
        return result;
    }

    public String getDescription(Object kind) {
        String result = this.getDescriptionStrict(kind);
        if (result == null) {
            return (String)this.getItem("description-" + DEFAULT);
        }
        return result;
    }

    public String getDescriptionStrict(Object kind) {
        return (String)this.getItem("description-" + kind);
    }

    public IconDesc[] getIcons(Object kind) {
        List<Object> icons = this.getItems("icon-" + kind);
        return icons.toArray(new IconDesc[icons.size()]);
    }

    public URL getIconLocation(Object kind, int width, int height) {
        IconDesc[] icons = this.getIcons(kind);
        if (icons.length == 0) {
            return null;
        }
        IconDesc best = null;
        for (IconDesc icon : icons) {
            if (icon.getWidth() < width || icon.getHeight() < height) continue;
            if (best == null) {
                best = icon;
            }
            if (icon.getWidth() > best.getWidth() || icon.getHeight() > best.getHeight()) continue;
            best = icon;
        }
        if (best == null) {
            best = icons[0];
        }
        return best.getLocation();
    }

    public Locale[] getLocales() {
        return this.locales;
    }

    public boolean isOfflineAllowed() {
        if (this.strict) {
            return null != this.getItem("offline-allowed");
        }
        return true;
    }

    public boolean isSharingAllowed() {
        return null != this.getItem("sharing-allowed");
    }

    public AssociationDesc[] getAssociations() {
        List<Object> associations = this.getItems("association");
        return associations.toArray(new AssociationDesc[associations.size()]);
    }

    public ShortcutDesc getShortcut() {
        return (ShortcutDesc)this.getItem("shortcut");
    }

    public RelatedContentDesc[] getRelatedContents() {
        List<Object> relatedContents = this.getItems("related-content");
        return relatedContents.toArray(new RelatedContentDesc[relatedContents.size()]);
    }

    protected Object getItem(Object key) {
        List<Object> items = this.getItems(key);
        if (items.isEmpty()) {
            return null;
        }
        return items.get(items.size() - 1);
    }

    protected List<Object> getItems(Object key) {
        if (this.info == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < this.info.size(); i += 2) {
            if (!this.info.get(i).equals(key)) continue;
            result.add(this.info.get(i + 1));
        }
        return result;
    }

    protected void addItem(String key, Object value) {
        if (this.info == null) {
            this.info = new ArrayList<Object>();
        }
        this.info.add(key);
        this.info.add(value);
    }
}

