/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.edges;

import java.util.ArrayList;
import javax.swing.Icon;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.api.datatables.DataTablesController;
import org.gephi.datalab.plugin.manipulators.GeneralColumnsAndRowChooser;
import org.gephi.datalab.plugin.manipulators.edges.BasicEdgesManipulator;
import org.gephi.datalab.plugin.manipulators.ui.GeneralChooseColumnsAndRowUI;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.GraphController;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CopyEdgeDataToOtherEdges
extends BasicEdgesManipulator
implements GeneralColumnsAndRowChooser {
    private Edge clickedEdge;
    private Edge[] edges;
    private Column[] columnsToCopyData;

    public void setup(Edge[] edges, Edge clickedEdge) {
        this.clickedEdge = clickedEdge;
        this.edges = edges;
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        ArrayList<Column> columnsToCopyDataList = new ArrayList<Column>();
        for (Column column : ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getEdgeTable()) {
            if (!ac.canChangeColumnData(column)) continue;
            columnsToCopyDataList.add(column);
        }
        this.columnsToCopyData = columnsToCopyDataList.toArray(new Column[0]);
    }

    public void execute() {
        if (this.columnsToCopyData.length >= 0) {
            AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
            ac.copyEdgeDataToOtherEdges(this.clickedEdge, this.edges, this.columnsToCopyData);
            ((DataTablesController)Lookup.getDefault().lookup(DataTablesController.class)).refreshCurrentTable();
        }
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(CopyEdgeDataToOtherEdges.class, (String)"CopyEdgeDataToOtherEdges.name");
    }

    public String getDescription() {
        return NbBundle.getMessage(CopyEdgeDataToOtherEdges.class, (String)"CopyEdgeDataToOtherEdges.description");
    }

    public boolean canExecute() {
        return this.edges.length > 1;
    }

    public ManipulatorUI getUI() {
        return new GeneralChooseColumnsAndRowUI(NbBundle.getMessage(CopyEdgeDataToOtherEdges.class, (String)"CopyEdgeDataToOtherEdges.ui.rowDescription"), NbBundle.getMessage(CopyEdgeDataToOtherEdges.class, (String)"CopyEdgeDataToOtherEdges.ui.columnsDescription"));
    }

    public int getType() {
        return 200;
    }

    public int getPosition() {
        return 200;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"DataLaboratoryPlugin/broom--arrow.png", (boolean)false);
    }

    @Override
    public Column[] getColumns() {
        return this.columnsToCopyData;
    }

    @Override
    public void setColumns(Column[] columnsToClearData) {
        this.columnsToCopyData = columnsToClearData;
    }

    @Override
    public Element[] getRows() {
        return this.edges;
    }

    @Override
    public Element getRow() {
        return this.clickedEdge;
    }

    @Override
    public void setRow(Element row) {
        this.clickedEdge = (Edge)row;
    }
}

