/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.track;

import java.io.File;
import java.io.FileFilter;
import org.fibs.geotag.util.FileUtil;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class GpxFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private static final I18n i18n = I18nFactory.getI18n(GpxFileFilter.class);

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return GpxFileFilter.isGpxFile(file);
    }

    public static boolean isGpxFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String extension = FileUtil.getExtension(file);
        return extension != null && extension.equals("gpx");
    }

    @Override
    public String getDescription() {
        return i18n.tr("GPX files");
    }
}

