/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.exif;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.fibs.geotag.Settings;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.data.UpdateCameraDate;
import org.fibs.geotag.data.UpdateCityName;
import org.fibs.geotag.data.UpdateCountryName;
import org.fibs.geotag.data.UpdateGPSAltitude;
import org.fibs.geotag.data.UpdateGPSDateTime;
import org.fibs.geotag.data.UpdateGPSImgDirection;
import org.fibs.geotag.data.UpdateGPSLatitude;
import org.fibs.geotag.data.UpdateGPSLongitude;
import org.fibs.geotag.data.UpdateLocationName;
import org.fibs.geotag.data.UpdateProvinceName;
import org.fibs.geotag.data.UpdateUserComment;
import org.fibs.geotag.exif.ExifReader;
import org.fibs.geotag.exif.Exiftool;
import org.fibs.geotag.image.FileTypes;
import org.fibs.geotag.util.Units;

public class ExiftoolReader
implements ExifReader {
    private static final String ERROR_TAG = "Error:";
    private static final String DATE_TIME_ORIGINAL_TAG = "DateTimeOriginal: ";
    private static final String CREATE_DATE_TAG = "CreateDate: ";
    private static final String GPS_LATITUDE_TAG = "GPSLatitude: ";
    private static final String GPS_LONGITUDE_TAG = "GPSLongitude: ";
    private static final String GPS_ALTITUDE_TAG = "GPSAltitude: ";
    private static final String GPS_IMG_DIRECTION_TAG = "GPSImgDirection: ";
    private static final String GPS_DATE_TIME_TAG = "GPSDateTime: ";
    private static final String GPS_TIME_STAMP_TAG = "GPSTimeStamp: ";
    private static final String ORIENTATION_TAG = "Orientation: ";
    private static final String IMAGE_WIDTH_TAG = "ImageWidth: ";
    private static final String IMAGE_HEIGHT_TAG = "ImageHeight: ";
    private static final String LOCATION_TAG = "ContentLocationName: ";
    private static final String SUB_LOCATION_TAG = "Sub-location: ";
    private static final String LOCATION_TAG_2 = "Location: ";
    private static final String CITY_TAG = "City: ";
    private static final String COUNTRY_TAG = "Country-PrimaryLocationName: ";
    private static final String COUNTRY_XMP_TAG = "Country: ";
    private static final String PROVINCE_TAG = "Province-State: ";
    private static final String STATE_TAG = "State: ";
    private static final String USER_COMMENT_TAG = "UserComment: ";

    private String[] exifToolArguments() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-S");
        args.add("-n");
        args.add("-CreateDate");
        args.add("-DateTimeOriginal");
        args.add("-GPSLatitude");
        args.add("-GPSLongitude");
        args.add("-GPSAltitude");
        args.add("-GPSImgDirection");
        args.add("-GPSImgDirectionRef");
        args.add("-GPSDateTime");
        args.add("-Orientation");
        args.add("-ImageWidth");
        args.add("-ImageHeight");
        args.add("-ContentLocationName");
        args.add("-Sub-Location");
        args.add("-City");
        args.add("-Country-PrimaryLocationName");
        args.add("-Province-State");
        args.add("-UserComment");
        return args.toArray(new String[0]);
    }

    private String[] exifToolXmpArguments() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-S");
        args.add("-n");
        args.add("-GPSLatitude");
        args.add("-GPSLongitude");
        args.add("-GPSAltitude");
        if (Exiftool.versionAtLeast(7, 4)) {
            args.add("-XMP:GPSTimeStamp");
        } else {
            args.add("-XMP:GPSDateTime");
        }
        args.add("-XMP:GPSImgDirection");
        args.add("-XMP:GPSImgDirectionRef");
        args.add("-XMP:Orientation");
        args.add("-XMP:ImageWidth");
        args.add("-XMP:ImageHeight");
        args.add("-XMP:Location");
        args.add("-XMP:City");
        args.add("-XMP:Country");
        args.add("-XMP:State");
        args.add("-XMP:UserComment");
        return args.toArray(new String[0]);
    }

    @Override
    public ImageInfo readExifData(File file, ImageInfo reuseImageInfo) {
        ImageInfo imageInfo = reuseImageInfo;
        ArrayList<String> command = new ArrayList<String>();
        command.add(Settings.get(Settings.SETTING.EXIFTOOL_PATH, "exiftool"));
        String[] arguments = this.exifToolArguments();
        if (FileTypes.fileType(file) == FileTypes.XMP) {
            arguments = this.exifToolXmpArguments();
        }
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String argument = stringArray[n2];
            command.add(argument);
            ++n2;
        }
        command.add(file.getPath());
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        try {
            Process process = processBuilder.redirectErrorStream(true).start();
            InputStream stream = process.getInputStream();
            imageInfo = this.readExifData(file, stream, imageInfo);
            stream.close();
            return imageInfo;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ImageInfo readExifData(File file, InputStream stream, ImageInfo reuseImageInfo) {
        ImageInfo imageInfo = reuseImageInfo;
        if (imageInfo == null && (imageInfo = ImageInfo.getImageInfo(file.getPath())) == null) {
            imageInfo = new ImageInfo(file);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, Charset.forName("UTF-8")));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String text = line;
                if (text.startsWith(DATE_TIME_ORIGINAL_TAG) || text.startsWith(CREATE_DATE_TAG)) {
                    String cameraDate = text.startsWith(DATE_TIME_ORIGINAL_TAG) ? text.substring(DATE_TIME_ORIGINAL_TAG.length()) : text.substring(CREATE_DATE_TAG.length());
                    new UpdateCameraDate(imageInfo, cameraDate);
                    imageInfo.setGpsDateTime();
                    continue;
                }
                if (text.startsWith(GPS_LATITUDE_TAG)) {
                    String latitude = text.substring(GPS_LATITUDE_TAG.length());
                    if ("0".equals(latitude)) continue;
                    new UpdateGPSLatitude(imageInfo, latitude, ImageInfo.DATA_SOURCE.IMAGE);
                    continue;
                }
                if (text.startsWith(GPS_LONGITUDE_TAG)) {
                    String longitude = text.substring(GPS_LONGITUDE_TAG.length());
                    if ("0".equals(longitude)) continue;
                    new UpdateGPSLongitude(imageInfo, longitude, ImageInfo.DATA_SOURCE.IMAGE);
                    continue;
                }
                if (text.startsWith(GPS_ALTITUDE_TAG)) {
                    String altitude = text.substring(GPS_ALTITUDE_TAG.length());
                    if ("undef".equals(altitude)) continue;
                    new UpdateGPSAltitude(imageInfo, altitude, ImageInfo.DATA_SOURCE.IMAGE, Units.ALTITUDE.METRES);
                    continue;
                }
                if (text.startsWith(GPS_IMG_DIRECTION_TAG)) {
                    String direction = text.substring(GPS_IMG_DIRECTION_TAG.length());
                    if ("undef".equals(direction)) continue;
                    new UpdateGPSImgDirection(imageInfo, direction, ImageInfo.DATA_SOURCE.IMAGE);
                    continue;
                }
                if (text.startsWith(GPS_DATE_TIME_TAG)) {
                    new UpdateGPSDateTime(imageInfo, text.substring(GPS_DATE_TIME_TAG.length()));
                    continue;
                }
                if (text.startsWith(GPS_TIME_STAMP_TAG)) {
                    if (!text.endsWith("Z")) continue;
                    String gpsDateTime = text.substring(GPS_TIME_STAMP_TAG.length(), text.length() - 1);
                    new UpdateGPSDateTime(imageInfo, gpsDateTime);
                    continue;
                }
                if (text.startsWith(ORIENTATION_TAG)) {
                    imageInfo.setOrientation(text.substring(ORIENTATION_TAG.length()));
                    continue;
                }
                if (text.startsWith(IMAGE_WIDTH_TAG)) {
                    try {
                        int width = Integer.parseInt(text.substring(IMAGE_WIDTH_TAG.length()));
                        imageInfo.setWidth(width);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (text.startsWith(IMAGE_HEIGHT_TAG)) {
                    try {
                        int height = Integer.parseInt(text.substring(IMAGE_HEIGHT_TAG.length()));
                        imageInfo.setHeight(height);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (text.startsWith(LOCATION_TAG)) {
                    new UpdateLocationName(imageInfo, text.substring(LOCATION_TAG.length()), ImageInfo.DATA_SOURCE.IMAGE);
                    continue;
                }
                if (text.startsWith(SUB_LOCATION_TAG)) {
                    new UpdateLocationName(imageInfo, text.substring(SUB_LOCATION_TAG.length()), ImageInfo.DATA_SOURCE.IMAGE);
                    continue;
                }
                if (text.startsWith(LOCATION_TAG_2)) {
                    new UpdateLocationName(imageInfo, text.substring(LOCATION_TAG_2.length()), ImageInfo.DATA_SOURCE.IMAGE);
                    continue;
                }
                if (text.startsWith(CITY_TAG)) {
                    new UpdateCityName(imageInfo, text.substring(CITY_TAG.length()), ImageInfo.DATA_SOURCE.IMAGE);
                    continue;
                }
                if (text.startsWith(COUNTRY_TAG)) {
                    new UpdateCountryName(imageInfo, text.substring(COUNTRY_TAG.length()), ImageInfo.DATA_SOURCE.IMAGE);
                    continue;
                }
                if (text.startsWith(COUNTRY_XMP_TAG)) {
                    new UpdateCountryName(imageInfo, text.substring(COUNTRY_XMP_TAG.length()), ImageInfo.DATA_SOURCE.IMAGE);
                    continue;
                }
                if (text.startsWith(PROVINCE_TAG)) {
                    new UpdateProvinceName(imageInfo, text.substring(PROVINCE_TAG.length()), ImageInfo.DATA_SOURCE.IMAGE);
                    continue;
                }
                if (text.startsWith(STATE_TAG)) {
                    new UpdateProvinceName(imageInfo, text.substring(STATE_TAG.length()), ImageInfo.DATA_SOURCE.IMAGE);
                    continue;
                }
                if (text.startsWith(USER_COMMENT_TAG)) {
                    new UpdateUserComment(imageInfo, text.substring(USER_COMMENT_TAG.length()), ImageInfo.DATA_SOURCE.IMAGE);
                    continue;
                }
                if (text.startsWith(ERROR_TAG)) {
                    throw new IllegalArgumentException(text);
                }
                System.out.println(text);
            }
            reader.close();
        }
        catch (Throwable e) {
            System.err.println(String.valueOf(this.getClass().getName()) + ": " + e.getMessage());
            return null;
        }
        return imageInfo;
    }
}

