/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.ResourceUtil;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.NavigatorResources;
import org.jkiss.dbeaver.ui.IDataSourceContainerUpdate;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorContext;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.SimpleDatabaseEditorContext;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;
import org.jkiss.dbeaver.ui.navigator.dialogs.SelectDataSourceDialog;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class NavigatorHandlerAssociateScript
extends NavigatorHandlerObjectBase {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ArrayList<IFile> selectedScripts = new ArrayList<IFile>();
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            for (Object o : (IStructuredSelection)selection) {
                IResource resource;
                DBNNode node = (DBNNode)RuntimeUtils.getObjectAdapter(o, DBNNode.class);
                if (!(node instanceof DBNResource) || !((resource = ((DBNResource)node).getResource()) instanceof IFile)) continue;
                selectedScripts.add((IFile)resource);
            }
        }
        if (!selectedScripts.isEmpty()) {
            SelectDataSourceDialog dialog = new SelectDataSourceDialog(activeShell, DBPPlatformDesktop.getInstance().getWorkspace().getProject(((IFile)selectedScripts.get(0)).getProject()), null);
            if (dialog.open() == 1) {
                return null;
            }
            DBPDataSourceContainer dataSource = dialog.getDataSource();
            for (IFile script : selectedScripts) {
                EditorUtils.setFileDataSource((IFile)script, (DatabaseEditorContext)new SimpleDatabaseEditorContext(dataSource));
                NavigatorHandlerAssociateScript.setEditorDataSource(script, dataSource);
                DBPProject project = dataSource != null ? dataSource.getProject() : DBPPlatformDesktop.getInstance().getWorkspace().getProject(script.getProject());
                if (project == null) continue;
                NavigatorResources.refreshNavigatorResource((DBPProject)project, (IResource)script, (Object)dataSource);
            }
        }
        return null;
    }

    private static void setEditorDataSource(IFile script, DBPDataSourceContainer dataSource) {
        for (IWorkbenchWindow window : PlatformUI.getWorkbench().getWorkbenchWindows()) {
            for (IWorkbenchPage page : window.getPages()) {
                IEditorPart editor = ResourceUtil.findEditor((IWorkbenchPage)page, (IFile)script);
                if (!(editor instanceof IDataSourceContainerUpdate)) continue;
                ((IDataSourceContainerUpdate)editor).setDataSourceContainer(dataSource);
            }
        }
    }
}

