/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.common.DateHelper;

public abstract class ProjectCalendarDays {
    private String m_name;
    private final ProjectCalendarHours[] m_hours = new ProjectCalendarHours[7];
    private final DayType[] m_days = new DayType[7];
    public static final DateRange DEFAULT_WORKING_MORNING = new DateRange(DateHelper.getTime(8, 0), DateHelper.getTime(12, 0));
    public static final DateRange DEFAULT_WORKING_AFTERNOON = new DateRange(DateHelper.getTime(13, 0), DateHelper.getTime(17, 0));

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public ProjectCalendarHours getCalendarHours(Day day) {
        return this.m_hours[day.getValue() - 1];
    }

    @Deprecated
    public ProjectCalendarHours[] getHours() {
        return this.m_hours;
    }

    public void addDefaultCalendarHours() {
        for (Day day : Day.values()) {
            this.addDefaultCalendarHours(day);
        }
    }

    public void addDefaultCalendarDays() {
        this.setWorkingDay(Day.SUNDAY, false);
        this.setWorkingDay(Day.MONDAY, true);
        this.setWorkingDay(Day.TUESDAY, true);
        this.setWorkingDay(Day.WEDNESDAY, true);
        this.setWorkingDay(Day.THURSDAY, true);
        this.setWorkingDay(Day.FRIDAY, true);
        this.setWorkingDay(Day.SATURDAY, false);
    }

    public void addDefaultCalendarHours(Day day) {
        ProjectCalendarHours hours = this.addCalendarHours(day);
        if (day != Day.SATURDAY && day != Day.SUNDAY) {
            hours.add(DEFAULT_WORKING_MORNING);
            hours.add(DEFAULT_WORKING_AFTERNOON);
        }
    }

    public ProjectCalendarHours addCalendarHours(Day day) {
        ProjectCalendarHours bch;
        this.m_hours[day.getValue() - 1] = bch = new ProjectCalendarHours();
        return bch;
    }

    public void removeCalendarHours(Day day) {
        this.m_hours[day.getValue() - 1] = null;
    }

    @Deprecated
    public DayType[] getDays() {
        return this.m_days;
    }

    @Deprecated
    public DayType getWorkingDay(Day day) {
        return this.m_days[day.getValue() - 1];
    }

    public DayType getCalendarDayType(Day day) {
        return this.m_days[day.getValue() - 1];
    }

    public void setWorkingDay(Day day, boolean working) {
        this.setCalendarDayType(day, working ? DayType.WORKING : DayType.NON_WORKING);
    }

    @Deprecated
    public void setWorkingDay(Day day, DayType working) {
        this.m_days[day.getValue() - 1] = working;
    }

    @Deprecated
    public void setDayType(Day day, DayType type) {
        this.setCalendarDayType(day, type);
    }

    public void setCalendarDayType(Day day, DayType type) {
        this.m_days[day.getValue() - 1] = type;
        switch (type) {
            case DEFAULT: {
                this.removeCalendarHours(day);
                break;
            }
            case NON_WORKING: {
                ProjectCalendarHours hours = this.getCalendarHours(day);
                if (hours == null) {
                    this.addCalendarHours(day);
                    break;
                }
                hours.clear();
                break;
            }
        }
    }
}

