﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/cost-optimization-hub/CostOptimizationHub_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CostOptimizationHub {
namespace Model {

/**
 * <p>The storage configuration used for recommendations.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/StorageConfiguration">AWS
 * API Reference</a></p>
 */
class StorageConfiguration {
 public:
  AWS_COSTOPTIMIZATIONHUB_API StorageConfiguration() = default;
  AWS_COSTOPTIMIZATIONHUB_API StorageConfiguration(Aws::Utils::Json::JsonView jsonValue);
  AWS_COSTOPTIMIZATIONHUB_API StorageConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_COSTOPTIMIZATIONHUB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The storage type.</p>
   */
  inline const Aws::String& GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  template <typename TypeT = Aws::String>
  void SetType(TypeT&& value) {
    m_typeHasBeenSet = true;
    m_type = std::forward<TypeT>(value);
  }
  template <typename TypeT = Aws::String>
  StorageConfiguration& WithType(TypeT&& value) {
    SetType(std::forward<TypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The storage volume.</p>
   */
  inline double GetSizeInGb() const { return m_sizeInGb; }
  inline bool SizeInGbHasBeenSet() const { return m_sizeInGbHasBeenSet; }
  inline void SetSizeInGb(double value) {
    m_sizeInGbHasBeenSet = true;
    m_sizeInGb = value;
  }
  inline StorageConfiguration& WithSizeInGb(double value) {
    SetSizeInGb(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_type;

  double m_sizeInGb{0.0};
  bool m_typeHasBeenSet = false;
  bool m_sizeInGbHasBeenSet = false;
};

}  // namespace Model
}  // namespace CostOptimizationHub
}  // namespace Aws
