/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.impl;

import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.security.x509.PKIXValidationInformation;

public class BasicPKIXValidationInformation
implements PKIXValidationInformation {
    @Nullable
    private final Collection<X509Certificate> trustAnchors;
    @Nullable
    private final Collection<X509CRL> trustedCRLs;
    @Nullable
    private final Integer verificationDepth;

    public BasicPKIXValidationInformation(@Nullable @ParameterName(name="anchors") Collection<X509Certificate> anchors, @Nullable @ParameterName(name="crls") Collection<X509CRL> crls, @Nullable @ParameterName(name="depth") Integer depth) {
        this.verificationDepth = depth;
        this.trustAnchors = anchors != null ? CollectionSupport.copyToList(anchors) : null;
        this.trustedCRLs = crls != null ? CollectionSupport.copyToList(crls) : null;
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    public Collection<X509CRL> getCRLs() {
        return this.trustedCRLs;
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    public Collection<X509Certificate> getCertificates() {
        return this.trustAnchors;
    }

    @Override
    @Nullable
    public Integer getVerificationDepth() {
        return this.verificationDepth;
    }
}

