/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.config.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.config.ConfigurationProperties;
import org.opensaml.core.config.ConfigurationPropertiesSource;
import org.opensaml.core.config.provider.PropertiesAdapter;
import org.slf4j.Logger;

public abstract class AbstractFilesystemConfigurationPropertiesSource
implements ConfigurationPropertiesSource {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractFilesystemConfigurationPropertiesSource.class);
    @Nullable
    private Properties cachedProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ConfigurationProperties getProperties() {
        String fileName = StringSupport.trimOrNull(this.getFilename());
        if (fileName == null) {
            this.log.warn("No filename was supplied, unable to load properties");
            return null;
        }
        AbstractFilesystemConfigurationPropertiesSource abstractFilesystemConfigurationPropertiesSource = this;
        synchronized (abstractFilesystemConfigurationPropertiesSource) {
            File file;
            if (this.cachedProperties == null && (file = new File(fileName)).exists()) {
                try (FileInputStream is = new FileInputStream(fileName);){
                    Properties props = new Properties();
                    props.load(is);
                    this.cachedProperties = props;
                }
                catch (FileNotFoundException e) {
                    this.log.warn("File not found attempting to load configuration properties '" + fileName + "' from filesystem");
                }
                catch (IOException e) {
                    this.log.warn("I/O problem attempting to load configuration properties '" + fileName + "' from filesystem", (Throwable)e);
                }
            }
            return this.cachedProperties != null ? new PropertiesAdapter(this.cachedProperties) : null;
        }
    }

    @Nullable
    protected abstract String getFilename();
}

